/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io.infinispan;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.jboss.byteman.contrib.bmunit.BMScript;
import org.jboss.byteman.contrib.bmunit.BMUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.uberfire.ext.metadata.backend.infinispan.utils.AttributesUtil;
import org.uberfire.ext.metadata.io.infinispan.BaseIndexTest;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@RunWith(value=BMUnitRunner.class)
@BMScript(dir="byteman", value="infinispan.btm")
public class ReplaceIndexedObjectTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{this.getSimpleName()};
    }

    @Test
    public void testIndexSameFileTwice() {
        Path file = this.ioService().get("git://" + this.getSimpleName() + "/path/to/file.txt", new String[0]);
        this.setupCountDown(1);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "file";
            }

            public Object value() {
                return "default://master@file/kie";
            }
        }});
        this.waitForCountDown(1000);
        this.setupCountDown(2);
        this.ioService().write(file, "some content here", Collections.emptySet(), new FileAttribute[]{new FileAttribute<Object>(){

            public String name() {
                return "file";
            }

            public Object value() {
                return "default://master@file/kies";
            }
        }});
        this.waitForCountDown(1000);
        List result = this.config.getIndexProvider().findByQuery(Arrays.asList(AttributesUtil.toProtobufFormat((String)(this.getSimpleName() + "/master"))), (Query)new MatchAllDocsQuery(), null, 0);
        Assert.assertEquals((long)1L, (long)result.size());
    }
}

