/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.metadata.io;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.junit.Assert;
import org.junit.Test;
import org.uberfire.commons.async.DescriptiveThreadFactory;
import org.uberfire.ext.metadata.engine.BatchIndexListener;
import org.uberfire.ext.metadata.engine.Indexer;
import org.uberfire.ext.metadata.engine.Observer;
import org.uberfire.ext.metadata.io.BatchIndex;
import org.uberfire.ext.metadata.io.IndexersFactory;
import org.uberfire.ext.metadata.io.KObjectUtil;
import org.uberfire.ext.metadata.io.lucene.BaseIndexTest;
import org.uberfire.ext.metadata.model.KCluster;
import org.uberfire.ext.metadata.model.KObject;
import org.uberfire.ext.metadata.model.KObjectKey;
import org.uberfire.io.attribute.DublinCoreView;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;

public class BatchIndexKeepFileTest
extends BaseIndexTest {
    @Override
    protected String[] getRepositoryNames() {
        return new String[]{"temp-repo-test"};
    }

    @Test
    public void testIndex() {
        Path file = this.ioService().get("git://temp-repo-test/xxx/.keep", new String[0]);
        this.ioService().write(file, "", new OpenOption[0]);
        IndexersFactory indexersFactory = this.indexersFactory();
        MockIndexer indexer = new MockIndexer();
        indexersFactory.addIndexer((Indexer)indexer);
        new BatchIndex(this.config.getIndexEngine(), new Observer(){

            public void information(String message) {
            }

            public void warning(String message) {
            }

            public void error(String message) {
            }
        }, Executors.newCachedThreadPool((ThreadFactory)new DescriptiveThreadFactory()), indexersFactory, this.indexerDispatcherFactory(this.config.getIndexEngine()), new BatchIndexListener(){

            public void notifyIndexIngStarted(KCluster kCluster, Path path) {
            }

            public void notifyIndexIngFinished(KCluster kCluster, Path path) {
            }
        }, new Class[]{DublinCoreView.class}).run(this.ioService().get("git://temp-repo-test/", new String[0]).getFileSystem(), () -> {
            try {
                String index = KObjectUtil.toKCluster((Path)this.ioService().get("git://temp-repo-test/", new String[0])).getClusterId();
                long hits = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)new MatchAllDocsQuery());
                Assert.assertEquals((long)4L, (long)hits);
                TermQuery query = new TermQuery(new Term("dcore.author", "name"));
                long hits2 = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
                Assert.assertEquals((long)2L, (long)hits2);
                query = new TermQuery(new Term("dcore.author", "second"));
                hits2 = this.config.getIndexProvider().findHitsByQuery(Arrays.asList(index), (Query)query);
                Assert.assertEquals((long)1L, (long)hits2);
                this.config.dispose();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                Assert.fail();
            }
        });
        Assert.assertEquals((long)1L, (long)indexer.getFoundPaths().size());
        Assert.assertEquals((Object)"/xxx/keep", (Object)((Path)indexer.getFoundPaths().iterator().next()).toString());
    }

    class MockIndexer
    implements Indexer {
        private Set<Path> foundPaths = new HashSet<Path>();

        MockIndexer() {
        }

        public boolean supportsPath(Path path) {
            this.foundPaths.add(path);
            return false;
        }

        public KObject toKObject(Path path) {
            return null;
        }

        public KObjectKey toKObjectKey(Path path) {
            return null;
        }

        private Set<Path> getFoundPaths() {
            return this.foundPaths;
        }
    }
}

