/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.messageconsole.client.console.MessageConsoleViewImpl;
import org.guvnor.messageconsole.client.console.resources.MessageConsoleResources;
import org.guvnor.messageconsole.events.FilteredMessagesEvent;
import org.guvnor.messageconsole.events.MessageUtils;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.guvnor.messageconsole.utils.CSVConverter;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.client.annotations.DefaultPosition;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.ext.widgets.common.client.menu.RefreshMenuBuilder;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@ApplicationScoped
@WorkbenchScreen(identifier="org.kie.workbench.common.screens.messageconsole.MessageConsole")
public class MessageConsoleScreen
implements RefreshMenuBuilder.SupportsRefresh {
    public static final String ALERTS = "org.kie.workbench.common.screens.messageconsole.MessageConsole";
    private Caller<BuildService> buildService;
    private Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;
    private MessageConsoleViewImpl view;
    private Event<NotificationEvent> workbenchNotification;
    private Module module;
    private Menus menus;
    private List<SystemMessage> messages;

    public MessageConsoleScreen() {
    }

    @Inject
    public MessageConsoleScreen(Caller<BuildService> buildService, Event<PublishBatchMessagesEvent> publishBatchMessagesEvent, MessageConsoleViewImpl view, Event<NotificationEvent> workbenchNotification) {
        this.buildService = buildService;
        this.publishBatchMessagesEvent = publishBatchMessagesEvent;
        this.view = view;
        this.workbenchNotification = workbenchNotification;
        this.makeMenuBar();
    }

    public void onFilteredMessagesEvent(@Observes FilteredMessagesEvent filteredMessagesEvent) {
        this.messages = filteredMessagesEvent.getMessages();
    }

    public void onRefresh() {
        this.view.showBusyIndicator(MessageConsoleResources.CONSTANTS.Refreshing());
        ((BuildService)this.buildService.call((RemoteCallback)new RemoteCallback<BuildResults>(){

            public void callback(BuildResults results) {
                PublishBatchMessagesEvent batchMessages = new PublishBatchMessagesEvent();
                batchMessages.setCleanExisting(true);
                batchMessages.setMessageType("BuildSystem");
                if (results.getMessages() != null) {
                    for (BuildMessage buildMessage : results.getMessages()) {
                        batchMessages.getMessagesToPublish().add(MessageUtils.convert((BuildMessage)buildMessage));
                    }
                }
                MessageConsoleScreen.this.publishBatchMessagesEvent.fire((Object)batchMessages);
                MessageConsoleScreen.this.view.hideBusyIndicator();
            }
        }, (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.view))).build(this.module);
    }

    private void makeMenuBar() {
        this.menus = ((MenuFactory.TopLevelMenusBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)((MenuFactory.TopLevelMenusBuilder)((MenuFactory.MenuBuilder)MenuFactory.newTopLevelMenu((String)MessageConsoleResources.CONSTANTS.ClearMessageConsole()).respondsWith(() -> {
            PublishBatchMessagesEvent batchMessages = new PublishBatchMessagesEvent();
            batchMessages.setCleanExisting(true);
            batchMessages.setMessagesToPublish(new ArrayList());
            this.publishBatchMessagesEvent.fire((Object)batchMessages);
        })).endMenu()).newTopLevelMenu(MessageConsoleResources.CONSTANTS.CopyMessageConsole()).respondsWith(() -> this.copyMessages())).endMenu()).newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new RefreshMenuBuilder((RefreshMenuBuilder.SupportsRefresh)this)).endMenu()).build();
    }

    public void copyMessages() {
        String csv;
        boolean ok;
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        table.add(Arrays.asList("Level", "Text", "File", "Column", "Line"));
        if (this.messages != null) {
            this.messages.forEach(m -> {
                String level = m.getLevel() != null ? m.getLevel().name() : "";
                String text = m.getText();
                String file = m.getPath() != null ? m.getPath().getFileName() : "";
                String column = Integer.toString(m.getColumn());
                String line = Integer.toString(m.getLine());
                table.add(Arrays.asList(level, text, file, column, line));
            });
        }
        if (ok = this.view.copyMessages(csv = CSVConverter.convertTable(table))) {
            this.workbenchNotification.fire((Object)new NotificationEvent(MessageConsoleResources.CONSTANTS.MessagesCopiedToClipboard(), NotificationEvent.NotificationType.INFO));
        } else {
            this.workbenchNotification.fire((Object)new NotificationEvent(MessageConsoleResources.CONSTANTS.MessagesNotCopiedToClipboard(), NotificationEvent.NotificationType.ERROR));
        }
    }

    public void selectedProjectChanged(@Observes WorkspaceProjectContextChangeEvent event) {
        this.module = event.getModule();
        ((MenuItem)this.menus.getItems().get(0)).setEnabled(this.module != null);
    }

    @DefaultPosition
    public Position getDefaultPosition() {
        return CompassPosition.SOUTH;
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.view.getTitle();
    }

    @WorkbenchPartView
    public Widget asWidget() {
        return this.view.asWidget();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        menusConsumer.accept(this.menus);
    }
}

