/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import org.guvnor.messageconsole.client.console.MessageConsoleServiceRow;
import org.guvnor.messageconsole.events.SystemMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MessageConsoleServiceRowTest {
    private static final String SESSION_ID = "sessionId";
    private static final String USER_ID = "userId";
    private static final int ROWS = 5;
    @Mock
    private SystemMessage message;
    protected List<MessageConsoleServiceRow> rows;

    @Before
    public void setup() {
        this.rows = new ArrayList<MessageConsoleServiceRow>();
        MessageConsoleServiceRow.resetSequence();
        IntStream.range(0, 5).forEach(i -> this.rows.add(new MessageConsoleServiceRow(SESSION_ID, USER_ID, this.message)));
    }

    @Test
    public void testSequence() {
        IntStream.range(0, 5).forEach(i -> Assert.assertEquals((long)i, (long)this.rows.get(i).getSequence()));
    }

    @Test
    public void testComparator() {
        this.rows.sort(MessageConsoleServiceRow.DESC_ORDER);
        IntStream.range(0, 5).forEach(i -> Assert.assertEquals((long)(5 - i - 1), (long)this.rows.get(i).getSequence()));
    }
}

