/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.client.console;

import com.google.gwt.view.client.ListDataProvider;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.event.Event;
import org.guvnor.messageconsole.client.console.MessageConsoleService;
import org.guvnor.messageconsole.client.console.MessageConsoleServiceRow;
import org.guvnor.messageconsole.events.FilteredMessagesEvent;
import org.guvnor.messageconsole.events.PublishMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.rpc.SessionInfo;

@RunWith(value=GwtMockitoTestRunner.class)
public class MessageConsoleServiceTest {
    @Mock
    private SyncBeanManager iocManager;
    @Mock
    private PlaceManager placeManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private User identity;
    @Mock
    private StubEventSource<FilteredMessagesEvent> filteredMessagesEvent;
    private MessageConsoleService service;

    @Before
    public void setup() {
        this.service = new MessageConsoleService(this.iocManager, this.placeManager, this.sessionInfo, this.identity, this.filteredMessagesEvent);
    }

    @Test
    public void testPublishMessagesSortsMessagesInReverseOrder() {
        PublishMessagesEvent event = new PublishMessagesEvent();
        SystemMessage systemMessage1 = new SystemMessage();
        SystemMessage systemMessage2 = new SystemMessage();
        event.setMessagesToPublish(Arrays.asList(systemMessage1, systemMessage2));
        this.service.publishMessages(event);
        ListDataProvider dataProvider = this.service.getDataProvider();
        List data = dataProvider.getList();
        Assert.assertEquals((long)2L, (long)data.size());
        Assert.assertEquals((long)1L, (long)((MessageConsoleServiceRow)data.get(0)).getSequence());
        Assert.assertEquals((long)0L, (long)((MessageConsoleServiceRow)data.get(1)).getSequence());
        ((StubEventSource)Mockito.verify(this.filteredMessagesEvent, (VerificationMode)Mockito.times((int)1))).fire(Mockito.any());
    }

    static class StubEventSource<T>
    implements Event<T> {
        StubEventSource() {
        }

        public void fire(T event) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public Event<T> select(Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }

        public <U extends T> Event<U> select(Class<U> subtype, Annotation ... qualifiers) {
            throw new UnsupportedOperationException("Not implemented.");
        }
    }
}

