/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.messageconsole.backend;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildMessage;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.messageconsole.events.MessageUtils;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;

@ApplicationScoped
public class BuildResultsObserver {
    @Inject
    private Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;

    public void addBuildMessages(@Observes BuildResults results) {
        PublishBatchMessagesEvent batchMessages = new PublishBatchMessagesEvent();
        batchMessages.setCleanExisting(true);
        batchMessages.setMessageType("BuildSystem");
        if (results.getMessages() != null) {
            for (BuildMessage buildMessage : results.getMessages()) {
                batchMessages.getMessagesToPublish().add(MessageUtils.convert((BuildMessage)buildMessage));
            }
        }
        this.publishBatchMessagesEvent.fire((Object)batchMessages);
    }

    public void addIncrementalBuildMessages(@Observes IncrementalBuildResults results) {
        PublishBatchMessagesEvent batchMessages = new PublishBatchMessagesEvent();
        batchMessages.setMessageType("BuildSystem");
        if (results.getAddedMessages() != null) {
            for (BuildMessage buildMessage : results.getAddedMessages()) {
                batchMessages.getMessagesToPublish().add(MessageUtils.convert((BuildMessage)buildMessage));
            }
        }
        if (results.getRemovedMessages() != null) {
            for (BuildMessage buildMessage : results.getRemovedMessages()) {
                batchMessages.getMessagesToUnpublish().add(MessageUtils.convert((BuildMessage)buildMessage));
            }
        }
        this.publishBatchMessagesEvent.fire((Object)batchMessages);
    }
}

