/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.experimental.service.storage.scoped.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.experimental.service.definition.ExperimentalFeatureDefRegistry;
import org.uberfire.experimental.service.events.PortableExperimentalFeatureModifiedEvent;
import org.uberfire.experimental.service.registry.ExperimentalFeature;
import org.uberfire.experimental.service.registry.impl.ExperimentalFeatureImpl;
import org.uberfire.experimental.service.storage.scoped.impl.AbstractExperimentalFeaturesStorageTest;
import org.uberfire.experimental.service.storage.scoped.impl.GlobalExperimentalFeaturesStorageImpl;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class GlobalExperimentalFeaturesStorageImplTest
extends AbstractExperimentalFeaturesStorageTest<GlobalExperimentalFeaturesStorageImpl> {
    @Mock
    private EventSourceMock<PortableExperimentalFeatureModifiedEvent> event;

    @Test
    public void testFirstLoad() {
        ((GlobalExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(new ArrayList<ExperimentalFeatureImpl>(((GlobalExperimentalFeaturesStorageImpl)this.storage).getFeatures()), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_1", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_3", false));
    }

    @Test
    public void testRegularLoad() throws IOException {
        Path path = this.fileSystem.getPath(((GlobalExperimentalFeaturesStorageImpl)this.storage).getStoragePath(), new String[0]);
        this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/global/regularFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
        ((GlobalExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).endBatch();
        this.verifyLoadedFeatures(new ArrayList<ExperimentalFeatureImpl>(((GlobalExperimentalFeaturesStorageImpl)this.storage).getFeatures()), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_1", true), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_3", true));
    }

    @Test
    public void testExtraFeaturesLoad() throws IOException {
        Path path = this.fileSystem.getPath(((GlobalExperimentalFeaturesStorageImpl)this.storage).getStoragePath(), new String[0]);
        this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/global/extraFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
        ((GlobalExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(new ArrayList<ExperimentalFeatureImpl>(((GlobalExperimentalFeaturesStorageImpl)this.storage).getFeatures()), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_1", true), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_3", true));
    }

    @Test
    public void testMissingFeaturesLoad() throws IOException {
        Path path = this.fileSystem.getPath(((GlobalExperimentalFeaturesStorageImpl)this.storage).getStoragePath(), new String[0]);
        this.ioService.write(path, IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/test/global/missingFeatures.txt"), (Charset)Charset.defaultCharset()), new OpenOption[0]);
        ((GlobalExperimentalFeaturesStorageImpl)this.storage).init(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.times((int)2))).exists((Path)Matchers.any());
        ((IOService)Mockito.verify((Object)this.ioService)).newInputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        this.verifyLoadedFeatures(new ArrayList<ExperimentalFeatureImpl>(((GlobalExperimentalFeaturesStorageImpl)this.storage).getFeatures()), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_1", true), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_3", true));
    }

    @Test
    public void testStoreFeature() throws IOException {
        this.testRegularLoad();
        ((GlobalExperimentalFeaturesStorageImpl)this.storage).store(new ExperimentalFeatureImpl("feature_1", true));
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService, (VerificationMode)Mockito.never())).endBatch();
        ((EventSourceMock)Mockito.verify(this.event, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((GlobalExperimentalFeaturesStorageImpl)this.storage).store(new ExperimentalFeatureImpl("globalFeature_1", false));
        ((IOService)Mockito.verify((Object)this.ioService)).newOutputStream((Path)Matchers.any(), new OpenOption[0]);
        ((IOService)Mockito.verify((Object)this.ioService)).startBatch(this.fileSystem);
        ((IOService)Mockito.verify((Object)this.ioService)).endBatch();
        ((EventSourceMock)Mockito.verify(this.event)).fire(Matchers.any());
        this.verifyLoadedFeatures(new ArrayList<ExperimentalFeatureImpl>(((GlobalExperimentalFeaturesStorageImpl)this.storage).getFeatures()), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_1", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_2", false), (ExperimentalFeature)new ExperimentalFeatureImpl("globalFeature_3", true));
    }

    @Override
    protected GlobalExperimentalFeaturesStorageImpl getStorageInstance() {
        return new GlobalExperimentalFeaturesStorageImpl(this.sessionInfo, this.ioService, (ExperimentalFeatureDefRegistry)this.defRegistry, this.event);
    }
}

