/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.ext.editor.commons.backend.service;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.editor.commons.backend.service.SaveAndRenameServiceImpl;
import org.uberfire.ext.editor.commons.file.DefaultMetadata;
import org.uberfire.ext.editor.commons.service.support.SupportsSaveAndRename;

@RunWith(value=MockitoJUnitRunner.class)
public class SaveAndRenameServiceImplTest {
    @Mock
    private SupportsSaveAndRename<String, DefaultMetadata> supportsSaveAndRename;
    private SaveAndRenameServiceImpl<String, DefaultMetadata> service;

    @Before
    public void setup() throws Exception {
        this.service = (SaveAndRenameServiceImpl)Mockito.spy((Object)new SaveAndRenameServiceImpl<String, DefaultMetadata>(){
            {
                this.init(SaveAndRenameServiceImplTest.this.supportsSaveAndRename);
            }
        });
    }

    @Test
    public void testRename() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        String newFileName = "newFileName";
        String comment = "comment";
        this.service.rename(path, "newFileName", "comment");
        ((SupportsSaveAndRename)Mockito.verify(this.supportsSaveAndRename)).rename(path, "newFileName", "comment");
    }

    @Test
    public void testSave() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        String content = "content";
        DefaultMetadata metadata = (DefaultMetadata)Mockito.mock(DefaultMetadata.class);
        String comment = "comment";
        this.service.save(path, (Object)"content", (Object)metadata, "comment");
        ((SupportsSaveAndRename)Mockito.verify(this.supportsSaveAndRename)).save(path, (Object)"content", (Object)metadata, "comment");
    }

    @Test
    public void testSaveAndRename() throws Exception {
        Path path = (Path)Mockito.mock(Path.class);
        String newFileName = "newFileName";
        DefaultMetadata metadata = (DefaultMetadata)Mockito.mock(DefaultMetadata.class);
        String content = "content";
        String comment = "comment";
        ((SaveAndRenameServiceImpl)Mockito.doReturn((Object)path).when(this.service)).save(path, (Object)"content", (Object)metadata, "comment");
        this.service.saveAndRename(path, "newFileName", (Object)metadata, (Object)"content", "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.service)).save(path, (Object)"content", (Object)metadata, "comment");
        ((SaveAndRenameServiceImpl)Mockito.verify(this.service)).rename(path, "newFileName", "comment");
    }
}

