/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.security;

import java.net.URI;
import java.util.Arrays;
import javax.enterprise.inject.Instance;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.uberfire.backend.server.security.FileSystemResourceAdaptor;
import org.uberfire.backend.server.security.IOServiceSecuritySetup;
import org.uberfire.backend.server.security.MockAuthenticationService;
import org.uberfire.backend.server.security.MockSecuredFilesystemProvider;
import org.uberfire.java.nio.base.FileSystemId;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.security.FileSystemAuthorizer;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.PermissionManager;
import org.uberfire.security.authz.PermissionTypeRegistry;
import org.uberfire.security.impl.authz.DefaultAuthorizationManager;
import org.uberfire.security.impl.authz.DefaultPermissionManager;
import org.uberfire.security.impl.authz.DefaultPermissionTypeRegistry;

@RunWith(value=MockitoJUnitRunner.class)
public class IOServiceSecuritySetupTest {
    @Mock
    Instance<AuthenticationService> authenticationManagers;
    AuthorizationManager authorizationManager;
    IOServiceSecuritySetup setupBean;

    @Before
    public void setup() {
        System.setProperty("org.uberfire.io.auth", MockAuthenticationService.class.getName());
        DefaultPermissionManager permissionManager = new DefaultPermissionManager((PermissionTypeRegistry)new DefaultPermissionTypeRegistry());
        this.authorizationManager = (AuthorizationManager)Mockito.spy((Object)new DefaultAuthorizationManager((PermissionManager)permissionManager));
        this.setupBean = new IOServiceSecuritySetup();
        this.setupBean.authenticationManagers = this.authenticationManagers;
        this.setupBean.authorizationManager = this.authorizationManager;
    }

    @After
    public void teardown() {
        System.clearProperty("org.uberfire.io.auth");
    }

    @Test
    public void testSystemPropertyAuthConfig() throws Exception {
        Mockito.when((Object)this.authenticationManagers.isUnsatisfied()).thenReturn((Object)true);
        this.setupBean.setup();
        MockSecuredFilesystemProvider mockFsp = MockSecuredFilesystemProvider.LATEST_INSTANCE;
        Assert.assertNotNull((Object)mockFsp.authenticator);
        Assert.assertNotNull((Object)mockFsp.authorizer);
        User user = mockFsp.authenticator.login("fake", "fake");
        Assert.assertEquals((Object)MockAuthenticationService.FAKE_USER.getIdentifier(), (Object)user.getIdentifier());
        FileSystem mockfs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystem mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Mockito.when((Object)((FileSystemId)mockedFSId).id()).thenReturn((Object)"mockFS");
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("/"));
        Mockito.when((Object)mockfs.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)mockedFSId);
        Assert.assertTrue((boolean)mockFsp.authorizer.authorize(mockfs, user));
    }

    @Test
    public void testCustomAuthenticatorBean() throws Exception {
        Mockito.when((Object)this.authenticationManagers.isUnsatisfied()).thenReturn((Object)false);
        AuthenticationService mockAuthenticationService = (AuthenticationService)Mockito.mock(AuthenticationService.class);
        Mockito.when((Object)this.authenticationManagers.get()).thenReturn((Object)mockAuthenticationService);
        this.setupBean.setup();
        AuthenticationService authenticator = MockSecuredFilesystemProvider.LATEST_INSTANCE.authenticator;
        authenticator.login("fake", "fake");
        ((AuthenticationService)Mockito.verify((Object)mockAuthenticationService)).login("fake", "fake");
    }

    @Test
    public void testCustomAuthorizerBean() throws Exception {
        Mockito.when((Object)this.authenticationManagers.isUnsatisfied()).thenReturn((Object)true);
        this.setupBean.setup();
        FileSystemAuthorizer installedAuthorizer = MockSecuredFilesystemProvider.LATEST_INSTANCE.authorizer;
        AuthenticationService installedAuthenticator = MockSecuredFilesystemProvider.LATEST_INSTANCE.authenticator;
        FileSystem mockfs = (FileSystem)Mockito.mock(FileSystem.class);
        FileSystem mockedFSId = (FileSystem)Mockito.mock(FileSystem.class, (MockSettings)Mockito.withSettings().extraInterfaces(new Class[]{FileSystemId.class}));
        Path rootPath = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)rootPath.toUri()).thenReturn((Object)URI.create("/"));
        Mockito.when((Object)mockfs.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)mockedFSId.getRootDirectories()).thenReturn(Arrays.asList(rootPath));
        Mockito.when((Object)rootPath.getFileSystem()).thenReturn((Object)mockedFSId);
        User fileSystemUser = installedAuthenticator.login("fake", "fake");
        installedAuthorizer.authorize(mockfs, fileSystemUser);
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)Mockito.any(FileSystemResourceAdaptor.class), (User)Mockito.any(User.class));
    }
}

