/*
 * Decompiled with CFR 0.152.
 */
package org.appformer.client.stateControl.registry.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.appformer.client.stateControl.registry.DefaultRegistry;
import org.appformer.client.stateControl.registry.RegistryChangeListener;

public class DefaultRegistryImpl<C>
implements DefaultRegistry<C> {
    private final Deque<C> items = new ArrayDeque<C>();
    private int maxStackSize = 200;
    private RegistryChangeListener registryChangeListener;

    @Override
    public void setMaxSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("The registry size should be a positive number");
        }
        this.maxStackSize = size;
    }

    @Override
    public void register(C item) {
        this.addIntoStack(item);
        this.notifyRegistryChange();
    }

    @Override
    public void clear() {
        this.items.clear();
        this.notifyRegistryChange();
    }

    @Override
    public List<C> getHistory() {
        return new ArrayList<C>(this.items);
    }

    @Override
    public void setRegistryChangeListener(RegistryChangeListener registryChangeListener) {
        this.registryChangeListener = registryChangeListener;
    }

    @Override
    public C peek() {
        return this.items.peek();
    }

    @Override
    public C pop() {
        C item = this.items.pop();
        this.notifyRegistryChange();
        return item;
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    private void notifyRegistryChange() {
        if (this.registryChangeListener != null) {
            this.registryChangeListener.notifyRegistryChange();
        }
    }

    private void addIntoStack(C item) {
        if (null != item) {
            if (this.items.size() + 1 > this.maxStackSize) {
                this.items.removeLast();
            }
            this.items.push(item);
        }
    }
}

