/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.storm.topology.FailedException;
import org.apache.storm.windowing.DefaultEvictionContext;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionPolicy;
import org.apache.storm.windowing.TriggerHandler;
import org.apache.storm.windowing.TriggerPolicy;

public class TimeTriggerPolicy<T>
implements TriggerPolicy<T, Void> {
    private static final Logger LOG = Logger.getLogger(TimeTriggerPolicy.class.getName());
    private final TriggerHandler handler;
    private final ScheduledExecutorService executor;
    private final EvictionPolicy<T, ?> evictionPolicy;
    private long duration;
    private ScheduledFuture<?> executorFuture;

    public TimeTriggerPolicy(long millis, TriggerHandler handler) {
        this(millis, handler, null);
    }

    public TimeTriggerPolicy(long millis, TriggerHandler handler, EvictionPolicy<T, ?> evictionPolicy) {
        this.duration = millis;
        this.handler = handler;
        ThreadFactory threadFactory = new ThreadFactory(){
            private int threadId = 0;

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setName(String.format("time-trigger-policy-%d", this.threadId++));
                thread.setDaemon(true);
                return thread;
            }
        };
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
        this.evictionPolicy = evictionPolicy;
    }

    @Override
    public void track(Event<T> event) {
        this.checkFailures();
    }

    @Override
    public void reset() {
        this.checkFailures();
    }

    @Override
    public void start() {
        this.executorFuture = this.executor.scheduleAtFixedRate(this.newTriggerTask(), this.duration, this.duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(2L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return "TimeTriggerPolicy{duration=" + this.duration + '}';
    }

    private void checkFailures() {
        if (this.executorFuture != null && this.executorFuture.isDone()) {
            try {
                this.executorFuture.get();
            }
            catch (InterruptedException ex) {
                LOG.log(Level.SEVERE, "Got exception ", ex);
                throw new FailedException(ex);
            }
            catch (ExecutionException ex) {
                LOG.log(Level.SEVERE, "Got exception ", ex);
                throw new FailedException(ex.getCause());
            }
        }
    }

    private Runnable newTriggerTask() {
        return () -> {
            long now = System.currentTimeMillis() - 1L;
            try {
                this.evictionPolicy.setContext(new DefaultEvictionContext(now, null, null, this.duration));
                this.handler.onTrigger();
            }
            catch (Throwable th) {
                LOG.log(Level.SEVERE, "handler.onTrigger failed ", th);
                throw th;
            }
        };
    }

    @Override
    public Void getState() {
        return null;
    }

    @Override
    public void restoreState(Void state) {
    }
}

