/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology.twister2;

import edu.iu.dsc.tws.api.compute.TaskContext;
import edu.iu.dsc.tws.api.compute.nodes.ISource;
import edu.iu.dsc.tws.api.config.Config;
import java.util.logging.Logger;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.twister2.EdgeFieldMap;
import org.apache.storm.topology.twister2.Twister2SpoutDeclarer;
import org.apache.storm.topology.twister2.Twister2StormNode;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class Twister2Spout
implements ISource,
Twister2StormNode {
    private static final Logger LOG = Logger.getLogger(Twister2Spout.class.getName());
    private IRichSpout stormSpout;
    private Twister2SpoutDeclarer spoutDeclarer;
    private Integer parallelism = 1;
    private String id;
    private EdgeFieldMap outFieldsForEdge;
    private EdgeFieldMap keyedOutEdges;

    public Twister2Spout(String id, IRichSpout stormSpout) {
        this.id = id;
        this.stormSpout = stormSpout;
        this.spoutDeclarer = new Twister2SpoutDeclarer();
        this.outFieldsForEdge = new EdgeFieldMap(Utils.getDefaultStream(id));
        this.keyedOutEdges = new EdgeFieldMap(Utils.getDefaultStream(id));
        this.stormSpout.declareOutputFields(this.outFieldsForEdge);
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public Twister2SpoutDeclarer getSpoutDeclarer() {
        return this.spoutDeclarer;
    }

    @Override
    public Fields getOutFieldsForEdge(String edge) {
        return (Fields)this.outFieldsForEdge.get(edge);
    }

    @Override
    public void setKeyedOutEdges(String edge, Fields keys) {
        LOG.info(String.format("[Storm-Spout : %s] Setting out edge %s with keys %s", this.id, edge, keys));
        this.keyedOutEdges.put(edge, keys);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void execute() {
        this.stormSpout.nextTuple();
    }

    public void prepare(Config cfg, TaskContext context) {
        LOG.info("Preparing storm-spout : " + this.id);
        this.stormSpout.open(cfg.toMap(), new TopologyContext(context), new SpoutOutputCollector(this.id, context, this.outFieldsForEdge, this.keyedOutEdges));
    }
}

