/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.tuple;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Fields
implements Iterable<String>,
Serializable {
    private List<String> fields;
    private Map<String, Integer> index = new HashMap<String, Integer>();

    public Fields(String ... fields) {
        this(Arrays.asList(fields));
    }

    public Fields(List<String> fields) {
        this.fields = new ArrayList<String>(fields.size());
        for (String field : fields) {
            if (this.fields.contains(field)) {
                throw new IllegalArgumentException(String.format("duplicate field '%s'", field));
            }
            this.fields.add(field);
        }
        this.index();
    }

    public List<Object> select(Fields selector, List<Object> tuple) {
        ArrayList<Object> ret = new ArrayList<Object>(selector.size());
        for (String s : selector) {
            ret.add(tuple.get(this.fieldIndex(s)));
        }
        return ret;
    }

    public List<String> toList() {
        return new ArrayList<String>(this.fields);
    }

    public int size() {
        return this.fields.size();
    }

    public String get(int fieldIndex) {
        return this.fields.get(fieldIndex);
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.iterator();
    }

    public int fieldIndex(String field) {
        Integer ret = this.index.get(field);
        if (ret == null) {
            throw new IllegalArgumentException(field + " does not exist");
        }
        return ret;
    }

    public boolean contains(String field) {
        return this.index.containsKey(field);
    }

    private void index() {
        for (int i = 0; i < this.fields.size(); ++i) {
            this.index.put(this.fields.get(i), i);
        }
    }

    public String toString() {
        return this.fields.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Fields) {
            Fields of = (Fields)other;
            return this.fields.equals(of.fields);
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }
}

