/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.state;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.storm.state.State;
import org.apache.storm.state.StateProvider;
import org.apache.storm.task.TopologyContext;

public final class StateFactory {
    private static final Logger LOG = Logger.getLogger(StateFactory.class.getName());
    private static final String DEFAULT_PROVIDER = "org.apache.storm.state.InMemoryKeyValueStateProvider";

    private StateFactory() {
    }

    public static State getState(String namespace, Map<String, Object> topoConf, TopologyContext context) {
        State state;
        try {
            String provider = null;
            provider = topoConf.containsKey("topology.state.provider") ? (String)topoConf.get("topology.state.provider") : DEFAULT_PROVIDER;
            Class<?> klazz = Class.forName(provider);
            Object object = klazz.newInstance();
            if (!(object instanceof StateProvider)) {
                String msg = "Invalid state provider '" + provider + "'. Should implement org.apache.storm.state.StateProvider";
                LOG.log(Level.SEVERE, msg);
                throw new RuntimeException(msg);
            }
            state = ((StateProvider)object).newState(namespace, topoConf, context);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Got exception while loading the state provider", ex);
            throw new RuntimeException(ex);
        }
        return state;
    }
}

