/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.spout;

import edu.iu.dsc.tws.api.compute.TaskContext;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.storm.spout.ISpoutOutputCollector;
import org.apache.storm.topology.twister2.EdgeFieldMap;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Twister2TupleWrapper;
import org.apache.storm.utils.Utils;

public class SpoutOutputCollector
implements ISpoutOutputCollector {
    private static final Logger LOG = Logger.getLogger(SpoutOutputCollector.class.getName());
    private final TaskContext taskContext;
    private final String spoutId;
    private final EdgeFieldMap keyedOutEdges;
    private final EdgeFieldMap outFieldsForEdge;

    public SpoutOutputCollector(String spoutId, TaskContext taskContext, EdgeFieldMap outFieldsForEdge, EdgeFieldMap keyedOutEdges) {
        this.spoutId = spoutId;
        this.taskContext = taskContext;
        this.keyedOutEdges = keyedOutEdges;
        this.outFieldsForEdge = outFieldsForEdge;
    }

    public List<Integer> emit(List<Object> tuple) {
        return this.emit(tuple, null);
    }

    public List<Integer> emit(List<Object> tuple, Object messageId) {
        return this.emit(Utils.getDefaultStream(this.spoutId), tuple, messageId);
    }

    @Override
    public List<Integer> emit(String streamId, List<Object> tuple, Object messageId) {
        LOG.finest("Writing to the stream " + streamId + " data : " + tuple);
        Twister2TupleWrapper tupleWrapper = new Twister2TupleWrapper(tuple);
        if (!this.keyedOutEdges.containsKey(streamId)) {
            this.taskContext.write(streamId, (Object)tupleWrapper);
        } else {
            Fields allFields = (Fields)this.outFieldsForEdge.get(streamId);
            Fields fieldsForKey = (Fields)this.keyedOutEdges.get(streamId);
            List<Object> key = allFields.select(fieldsForKey, tuple);
            this.taskContext.write(streamId, key, (Object)tupleWrapper);
        }
        return Collections.singletonList(0);
    }

    @Override
    public void emitDirect(int taskId, String streamId, List<Object> tuple, Object messageId) {
    }

    @Override
    public void reportError(Throwable error) {
    }
}

