/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import com.google.gson.Gson;
import edu.iu.dsc.tws.api.JobConfig;
import edu.iu.dsc.tws.api.Twister2Job;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.rsched.core.ResourceAllocator;
import edu.iu.dsc.tws.rsched.job.Twister2Submitter;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.topology.twister2.Twister2StormWorker;

public final class StormSubmitter {
    private StormSubmitter() {
    }

    public static void submitTopology(String name, Map stormConfig, StormTopology topology) {
        Config config = ResourceAllocator.loadConfig(new HashMap());
        JobConfig jobConfig = new JobConfig();
        jobConfig.putAll(stormConfig);
        Gson gson = new Gson();
        String tg = gson.toJson((Object)topology.getT2ComputeGraph());
        jobConfig.put((Object)"storm-topology", (Object)topology.getT2ComputeGraph());
        Twister2Job.Twister2JobBuilder jobBuilder = Twister2Job.newBuilder();
        jobBuilder.setJobName(name);
        jobBuilder.setWorkerClass(Twister2StormWorker.class.getName());
        jobBuilder.setConfig(jobConfig);
        jobBuilder.addComputeResource(1.0, 512, 1);
        Twister2Submitter.submitJob((Twister2Job)jobBuilder.build(), (Config)config);
    }
}

