/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.windowing.TupleWindow;

public class TupleWindowIterImpl
implements TupleWindow {
    private final Supplier<Iterator<Tuple>> tuplesIt;
    private final Supplier<Iterator<Tuple>> newTuplesIt;
    private final Supplier<Iterator<Tuple>> expiredTuplesIt;
    private final Long startTimestamp;
    private final Long endTimestamp;

    public TupleWindowIterImpl(Supplier<Iterator<Tuple>> tuplesIt, Supplier<Iterator<Tuple>> newTuplesIt, Supplier<Iterator<Tuple>> expiredTuplesIt, Long startTimestamp, Long endTimestamp) {
        this.tuplesIt = tuplesIt;
        this.newTuplesIt = newTuplesIt;
        this.expiredTuplesIt = expiredTuplesIt;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
    }

    @Override
    public List<Tuple> get() {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        this.tuplesIt.get().forEachRemaining(t -> tuples.add((Tuple)t));
        return tuples;
    }

    @Override
    public Iterator<Tuple> getIter() {
        final Iterator<Tuple> modifiableItr = this.tuplesIt.get();
        return new Iterator<Tuple>(){

            @Override
            public boolean hasNext() {
                return modifiableItr.hasNext();
            }

            @Override
            public Tuple next() {
                return (Tuple)modifiableItr.next();
            }
        };
    }

    @Override
    public List<Tuple> getNew() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public List<Tuple> getExpired() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public Long getEndTimestamp() {
        return this.endTimestamp;
    }

    @Override
    public Long getStartTimestamp() {
        return this.startTimestamp;
    }
}

