/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.logging.Logger;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionContext;
import org.apache.storm.windowing.EvictionPolicy;

public class TimeEvictionPolicy<T>
implements EvictionPolicy<T, EvictionContext> {
    private static final Logger LOG = Logger.getLogger(TimeEvictionPolicy.class.getName());
    private final int windowLength;
    protected volatile EvictionContext evictionContext;
    private long delta;

    public TimeEvictionPolicy(int windowLength) {
        this.windowLength = windowLength;
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        long now = this.evictionContext == null ? System.currentTimeMillis() : this.evictionContext.getReferenceTime();
        long diff = now - event.getTimestamp();
        if (diff >= (long)this.windowLength + this.delta) {
            return EvictionPolicy.Action.EXPIRE;
        }
        if (diff < 0L) {
            return EvictionPolicy.Action.KEEP;
        }
        return EvictionPolicy.Action.PROCESS;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public EvictionContext getContext() {
        return this.evictionContext;
    }

    @Override
    public void setContext(EvictionContext context) {
        EvictionContext prevContext = this.evictionContext;
        this.evictionContext = context;
        if (context.getSlidingInterval() != null) {
            if (prevContext == null) {
                this.delta = Integer.MAX_VALUE;
            } else {
                this.delta = context.getReferenceTime() - prevContext.getReferenceTime() - context.getSlidingInterval();
                if (Math.abs(this.delta) > 100L) {
                    LOG.warning(() -> String.format("Possible clock drift or long running computation in window; Previous eviction time: %s, current eviction time: %s", prevContext.getReferenceTime(), context.getReferenceTime()));
                }
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public EvictionContext getState() {
        return this.evictionContext;
    }

    @Override
    public void restoreState(EvictionContext state) {
        this.evictionContext = state;
    }

    public String toString() {
        return "TimeEvictionPolicy{windowLength=" + this.windowLength + ", evictionContext=" + this.evictionContext + '}';
    }
}

