/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology.twister2;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.grouping.CustomStreamGrouping;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.twister2.GroupingTechnique;
import org.apache.storm.topology.twister2.MadeASourceListener;
import org.apache.storm.topology.twister2.Twister2BoltGrouping;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class Twister2BoltDeclarer
implements BoltDeclarer,
Serializable {
    private final HashMap<String, Object> configuration = new HashMap();
    private boolean debugOn;
    private Number maxTParallelism;
    private Number maxSpPending;
    private Number nTasks;
    private transient MadeASourceListener madeASourceListener;
    private List<Twister2BoltGrouping> groupings = new ArrayList<Twister2BoltGrouping>();

    public Twister2BoltDeclarer(MadeASourceListener madeASourceListener) {
        this.madeASourceListener = madeASourceListener;
    }

    @Override
    public BoltDeclarer addConfigurations(Map conf) {
        this.configuration.putAll(conf);
        return this;
    }

    @Override
    public BoltDeclarer addConfiguration(String config, Object value) {
        this.configuration.put(config, value);
        return this;
    }

    @Override
    public BoltDeclarer setDebug(boolean debug) {
        this.debugOn = debug;
        return this;
    }

    @Override
    public BoltDeclarer setMaxTaskParallelism(Number val) {
        this.maxTParallelism = val;
        return this;
    }

    @Override
    public BoltDeclarer setMaxSpoutPending(Number val) {
        this.maxSpPending = val;
        return this;
    }

    @Override
    public BoltDeclarer setNumTasks(Number val) {
        this.nTasks = val;
        return this;
    }

    @Override
    public BoltDeclarer fieldsGrouping(String componentId, Fields fields) {
        return this.fieldsGrouping(componentId, Utils.getDefaultStream(componentId), fields);
    }

    @Override
    public BoltDeclarer fieldsGrouping(String componentId, String streamId, Fields fields) {
        this.addGrouping(componentId, streamId, GroupingTechnique.FIELD).setGroupingKey(fields);
        this.madeASourceListener.onMadeASource(componentId);
        return this;
    }

    @Override
    public BoltDeclarer globalGrouping(String componentId) {
        return this.globalGrouping(componentId, Utils.getDefaultStream(componentId));
    }

    @Override
    public BoltDeclarer globalGrouping(String componentId, String streamId) {
        this.madeASourceListener.onMadeASource(componentId);
        return this;
    }

    @Override
    public BoltDeclarer shuffleGrouping(String componentId) {
        return this.shuffleGrouping(componentId, Utils.getDefaultStream(componentId));
    }

    @Override
    public BoltDeclarer shuffleGrouping(String componentId, String streamId) {
        this.addGrouping(componentId, streamId, GroupingTechnique.SHUFFLE);
        this.madeASourceListener.onMadeASource(componentId);
        return this;
    }

    @Override
    public BoltDeclarer localOrShuffleGrouping(String componentId) {
        return this.localOrShuffleGrouping(componentId, Utils.getDefaultStream(componentId));
    }

    @Override
    public BoltDeclarer localOrShuffleGrouping(String componentId, String streamId) {
        return this;
    }

    @Override
    public BoltDeclarer noneGrouping(String componentId) {
        return this.noneGrouping(componentId, Utils.getDefaultStream(componentId));
    }

    @Override
    public BoltDeclarer noneGrouping(String componentId, String streamId) {
        return this;
    }

    @Override
    public BoltDeclarer allGrouping(String componentId) {
        return this.allGrouping(componentId, Utils.getDefaultStream(componentId));
    }

    @Override
    public BoltDeclarer allGrouping(String componentId, String streamId) {
        this.addGrouping(componentId, streamId, GroupingTechnique.ALL);
        return this;
    }

    @Override
    public BoltDeclarer directGrouping(String componentId) {
        return this.directGrouping(componentId, Utils.getDefaultStream(componentId));
    }

    @Override
    public BoltDeclarer directGrouping(String componentId, String streamId) {
        this.addGrouping(componentId, streamId, GroupingTechnique.DIRECT);
        return this;
    }

    @Override
    public BoltDeclarer customGrouping(String componentId, CustomStreamGrouping grouping) {
        return this.customGrouping(componentId, Utils.getDefaultStream(componentId), grouping);
    }

    @Override
    public BoltDeclarer customGrouping(String componentId, String streamId, CustomStreamGrouping grouping) {
        return this;
    }

    private Twister2BoltGrouping addGrouping(String componentId, String streamId, GroupingTechnique technique) {
        Twister2BoltGrouping t2BoltGrouping = new Twister2BoltGrouping();
        t2BoltGrouping.setComponentId(componentId);
        t2BoltGrouping.setStreamId(streamId);
        t2BoltGrouping.setGroupingTechnique(technique);
        this.groupings.add(t2BoltGrouping);
        return t2BoltGrouping;
    }

    public HashMap<String, Object> getConfiguration() {
        return this.configuration;
    }

    public boolean isDebug() {
        return this.debugOn;
    }

    public Number getMaxTaskParallelism() {
        return this.maxTParallelism;
    }

    public Number getMaxSpoutPending() {
        return this.maxSpPending;
    }

    public Number getNumTasks() {
        return this.nTasks;
    }

    public List<Twister2BoltGrouping> getGroupings() {
        return this.groupings;
    }
}

