/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology.base;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.IWindowedBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TupleFieldTimestampExtractor;
import org.apache.storm.windowing.TimestampExtractor;

public abstract class BaseWindowedBolt
implements IWindowedBolt {
    protected final Map<String, Object> windowConfiguration = new HashMap<String, Object>();
    protected TimestampExtractor timestampExtractor;

    protected BaseWindowedBolt() {
    }

    private BaseWindowedBolt withWindowLength(Count count) {
        if (count == null) {
            throw new IllegalArgumentException("Window length count cannot be set null");
        }
        if (count.value <= 0) {
            throw new IllegalArgumentException("Window length must be positive [" + count + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.length.count", count.value);
        return this;
    }

    private BaseWindowedBolt withWindowLength(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Window length duration cannot be set null");
        }
        if (duration.value <= 0) {
            throw new IllegalArgumentException("Window length must be positive [" + duration + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.length.duration.ms", duration.value);
        return this;
    }

    private BaseWindowedBolt withSlidingInterval(Count count) {
        if (count == null) {
            throw new IllegalArgumentException("Sliding interval count cannot be set null");
        }
        if (count.value <= 0) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + count + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.sliding.interval.count", count.value);
        return this;
    }

    private BaseWindowedBolt withSlidingInterval(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Sliding interval duration cannot be set null");
        }
        if (duration.value <= 0) {
            throw new IllegalArgumentException("Sliding interval must be positive [" + duration + "]");
        }
        this.windowConfiguration.put("topology.bolts.window.sliding.interval.duration.ms", duration.value);
        return this;
    }

    public BaseWindowedBolt withWindow(Count windowLength, Count slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Count windowLength, Duration slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Duration windowLength, Count slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Duration windowLength, Duration slidingInterval) {
        return this.withWindowLength(windowLength).withSlidingInterval(slidingInterval);
    }

    public BaseWindowedBolt withWindow(Count windowLength) {
        return this.withWindowLength(windowLength).withSlidingInterval(new Count(1));
    }

    public BaseWindowedBolt withWindow(Duration windowLength) {
        return this.withWindowLength(windowLength).withSlidingInterval(new Count(1));
    }

    public BaseWindowedBolt withTumblingWindow(Count count) {
        return this.withWindowLength(count).withSlidingInterval(count);
    }

    public BaseWindowedBolt withTumblingWindow(Duration duration) {
        return this.withWindowLength(duration).withSlidingInterval(duration);
    }

    public BaseWindowedBolt withTimestampField(String fieldName) {
        return this.withTimestampExtractor(TupleFieldTimestampExtractor.of(fieldName));
    }

    public BaseWindowedBolt withTimestampExtractor(TimestampExtractor timestampExtr) {
        if (timestampExtr == null) {
            throw new IllegalArgumentException("Timestamp extractor cannot be set to null");
        }
        if (this.timestampExtractor != null) {
            throw new IllegalArgumentException("Window is already configured with a timestamp extractor: " + timestampExtr);
        }
        this.timestampExtractor = timestampExtr;
        return this;
    }

    @Override
    public TimestampExtractor getTimestampExtractor() {
        return this.timestampExtractor;
    }

    public BaseWindowedBolt withLateTupleStream(String streamId) {
        if (streamId == null) {
            throw new IllegalArgumentException("Cannot set late tuple stream id to null");
        }
        this.windowConfiguration.put("topology.bolts.late.tuple.stream", streamId);
        return this;
    }

    public BaseWindowedBolt withLag(Duration duration) {
        this.windowConfiguration.put("topology.bolts.tuple.timestamp.max.lag.ms", duration.value);
        return this;
    }

    public BaseWindowedBolt withWatermarkInterval(Duration interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Watermark interval cannot be set null");
        }
        this.windowConfiguration.put("topology.bolts.watermark.event.interval.ms", interval.value);
        return this;
    }

    @Override
    public void prepare(Map topoConf, TopologyContext context, OutputCollector collector) {
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this.windowConfiguration;
    }

    public static class Duration
    implements Serializable {
        public final int value;

        public Duration(int value, TimeUnit timeUnit) {
            if (value < 0) {
                throw new IllegalArgumentException("Duration cannot be negative");
            }
            long longVal = timeUnit.toMillis(value);
            if (longVal > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Duration is too long");
            }
            this.value = (int)longVal;
        }

        public static Duration of(int milliseconds) {
            return new Duration(milliseconds, TimeUnit.MILLISECONDS);
        }

        public static Duration days(int days) {
            return new Duration(days, TimeUnit.DAYS);
        }

        public static Duration hours(int hours) {
            return new Duration(hours, TimeUnit.HOURS);
        }

        public static Duration minutes(int minutes) {
            return new Duration(minutes, TimeUnit.MINUTES);
        }

        public static Duration seconds(int seconds) {
            return new Duration(seconds, TimeUnit.SECONDS);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Duration duration = (Duration)o;
            return this.value == duration.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "Duration{value=" + this.value + '}';
        }
    }

    public static class Count
    implements Serializable {
        public final int value;

        public Count(int value) {
            this.value = value;
        }

        public static Count of(int value) {
            return new Count(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Count count = (Count)o;
            return this.value == count.value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "Count{value=" + this.value + '}';
        }
    }
}

