/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import edu.iu.dsc.tws.api.compute.TaskContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.topology.twister2.Twister2BoltDeclarer;
import org.apache.storm.topology.twister2.Twister2BoltGrouping;

public class TopologyContext {
    private TaskContext t2TaskContext;
    private Twister2BoltDeclarer boltDeclarer;

    public TopologyContext(TaskContext t2TaskContext) {
        this.t2TaskContext = t2TaskContext;
    }

    public int getThisTaskId() {
        return this.t2TaskContext.globalTaskId();
    }

    public String getThisComponentId() {
        return this.t2TaskContext.taskName();
    }

    public void setTempBoltDeclarer(Twister2BoltDeclarer t2bd) {
        this.boltDeclarer = t2bd;
    }

    public Set<String> getThisStreams() {
        if (this.boltDeclarer == null) {
            throw new RuntimeException("Couldn't determine streams for this Node");
        }
        return this.boltDeclarer.getGroupings().stream().map(Twister2BoltGrouping::getStreamId).collect(Collectors.toSet());
    }

    public Map<GlobalStreamId, Object> getThisSources() {
        if (this.boltDeclarer == null) {
            throw new RuntimeException("Couldn't determine sources for this Node");
        }
        HashMap<GlobalStreamId, Object> sourcesMap = new HashMap<GlobalStreamId, Object>();
        this.boltDeclarer.getGroupings().forEach(twister2BoltGrouping -> {
            GlobalStreamId globalStreamId = new GlobalStreamId();
            globalStreamId.set_componentId(twister2BoltGrouping.getComponentId());
            globalStreamId.set_streamId(twister2BoltGrouping.getStreamId());
            sourcesMap.put(globalStreamId, null);
        });
        return sourcesMap;
    }
}

