/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.io.Serializable;

public final class Pair<T1, T2>
implements Serializable {
    public final T1 val1;
    public final T2 val2;

    private Pair(T1 first, T2 second) {
        this.val1 = first;
        this.val2 = second;
    }

    public static <T1, T2> Pair<T1, T2> of(T1 first, T2 second) {
        return new Pair<T1, T2>(first, second);
    }

    public T1 getFirst() {
        return this.val1;
    }

    public T2 getSecond() {
        return this.val2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.val1 != null ? !this.val1.equals(pair.val1) : pair.val1 != null) {
            return false;
        }
        return this.val2 != null ? this.val2.equals(pair.val2) : pair.val2 == null;
    }

    public int hashCode() {
        int result = this.val1 != null ? this.val1.hashCode() : 0;
        result = 31 * result + (this.val2 != null ? this.val2.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "(" + this.val1 + ", " + this.val2 + ')';
    }
}

