/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.translators.functions;

import edu.iu.dsc.tws.api.tset.TSetContext;
import edu.iu.dsc.tws.api.tset.fn.ComputeCollectorFunc;
import edu.iu.dsc.tws.api.tset.fn.RecordCollector;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.beam.runners.twister2.utils.Twister2AssignContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.joda.time.Instant;

public class AssignWindowsFunction<T>
implements ComputeCollectorFunc<Iterator<WindowedValue<T>>, WindowedValue<T>> {
    private static final Logger LOG = Logger.getLogger(AssignWindowsFunction.class.getName());
    private final WindowFn<T, BoundedWindow> windowFn;

    public AssignWindowsFunction(WindowFn<T, BoundedWindow> windowFn) {
        this.windowFn = windowFn;
    }

    public void compute(Iterator<WindowedValue<T>> input, RecordCollector<WindowedValue<T>> output) {
        try {
            while (input.hasNext()) {
                WindowedValue<T> element = input.next();
                Collection windows = this.windowFn.assignWindows(new Twister2AssignContext<T, BoundedWindow>(this.windowFn, element));
                for (BoundedWindow window : windows) {
                    output.collect((Object)WindowedValue.of((Object)element.getValue(), (Instant)element.getTimestamp(), (BoundedWindow)window, (PaneInfo)element.getPane()));
                }
            }
        }
        catch (Exception e) {
            LOG.info(e.getMessage());
        }
    }

    public void prepare(TSetContext context) {
    }
}

