/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.twister2.examples;

import edu.iu.dsc.tws.api.resource.Twister2Worker;
import edu.iu.dsc.tws.api.resource.WorkerEnvironment;
import edu.iu.dsc.tws.tset.env.BatchEnvironment;
import edu.iu.dsc.tws.tset.env.TSetEnvironment;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.apache.beam.runners.twister2.Twister2LegacyRunner;
import org.apache.beam.runners.twister2.Twister2PipelineOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;

public class ReadSourceTest
implements Serializable,
Twister2Worker {
    private static final Logger LOG = Logger.getLogger(ReadSourceTest.class.getName());

    public void execute(WorkerEnvironment workerEnv) {
        BatchEnvironment env = TSetEnvironment.initBatch((WorkerEnvironment)workerEnv);
        System.out.println("Rank " + env.getWorkerID());
        Twister2PipelineOptions options = (Twister2PipelineOptions)PipelineOptionsFactory.as(Twister2PipelineOptions.class);
        options.setTSetEnvironment((TSetEnvironment)env);
        ((Twister2PipelineOptions)options.as(Twister2PipelineOptions.class)).setRunner(Twister2LegacyRunner.class);
        String resultPath = "/tmp/testdir";
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection result = (PCollection)((PCollection)p.apply((PTransform)GenerateSequence.from((long)0L).to(10L))).apply((PTransform)ParDo.of((DoFn)new DoFn<Long, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                c.output((Object)((Long)c.element()).toString());
            }
        }));
        try {
            result.apply((PTransform)TextIO.write().to(new URI(resultPath).getPath() + "/part"));
        }
        catch (URISyntaxException e) {
            LOG.info(e.getMessage());
        }
        p.run();
        System.out.println("Result " + result.toString());
    }
}

