/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.worker;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.exceptions.JobFaultyException;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.faulttolerance.JobProgress;
import edu.iu.dsc.tws.api.resource.IJobMasterFailureListener;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.IWorkerFailureListener;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.core.WorkerRuntime;
import edu.iu.dsc.tws.rsched.worker.JobProgressImpl;
import java.util.logging.Logger;

public class MPIWorkerManager
implements IWorkerFailureListener,
IJobMasterFailureListener {
    private static final Logger LOG = Logger.getLogger(MPIWorkerManager.class.getName());
    private boolean firstInitBarrierProceeded = false;

    public MPIWorkerManager() {
        WorkerRuntime.addWorkerFailureListener(this);
        WorkerRuntime.addJMFailureListener(this);
        JobProgressImpl.init();
    }

    public boolean execute(Config config, JobAPI.Job job, IWorkerController workerController, IPersistentVolume persistentVolume, IVolatileVolume volatileVolume, IWorker managedWorker) {
        int workerID = workerController.getWorkerInfo().getWorkerID();
        LOG.info("Waiting on the init barrier before starting IWorker: " + workerID + " with restartCount: " + workerController.workerRestartCount() + " and with re-executionCount: " + JobProgress.getWorkerExecuteCount());
        try {
            workerController.waitOnInitBarrier();
            this.firstInitBarrierProceeded = true;
        }
        catch (TimeoutException e) {
            throw new Twister2RuntimeException("Could not pass through the init barrier", (Throwable)e);
        }
        JobProgressImpl.setJobStatus(JobProgress.JobStatus.EXECUTING);
        JobProgressImpl.increaseWorkerExecuteCount();
        try {
            managedWorker.execute(config, job, workerController, persistentVolume, volatileVolume);
            return true;
        }
        catch (JobFaultyException jfe) {
            JobProgressImpl.setJobStatus(JobProgress.JobStatus.FAULTY);
            throw jfe;
        }
    }

    public void jmFailed() {
        if (!this.firstInitBarrierProceeded) {
            LOG.warning("Job Master failed event received before the first INIT barrier. Ignoring");
            return;
        }
        this.faultOccurred(-1);
    }

    public void jmRestarted(String jobMasterAddress) {
        if (!this.firstInitBarrierProceeded) {
            LOG.warning("Job Master restarted event received before the first INIT barrier. Ignoring");
            return;
        }
        this.faultOccurred(-1);
    }

    public void failed(int wID) {
        if (!this.firstInitBarrierProceeded) {
            LOG.fine("Worker failure event received before first INIT barrier. Failed worker: " + wID);
            return;
        }
        this.faultOccurred(wID);
    }

    public void restarted(JobMasterAPI.WorkerInfo workerInfo) {
        if (!this.firstInitBarrierProceeded) {
            LOG.fine("Worker restart event received before first INIT barrier. Restarted worker: " + workerInfo.getWorkerID());
            return;
        }
        this.faultOccurred(workerInfo.getWorkerID());
    }

    private void faultOccurred(int wID) {
        if (JobProgress.isJobHealthy()) {
            JobProgressImpl.setJobStatus(JobProgress.JobStatus.FAULTY);
            JobProgressImpl.faultOccurred(wID);
            throw new JobFaultyException("Worker[" + wID + "] failed");
        }
    }
}

