/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public final class FileUtils {
    private static final Logger LOG = Logger.getLogger(FileUtils.class.getName());

    private FileUtils() {
    }

    public static boolean writeToFile(String filename, byte[] contents, boolean overwrite) {
        OpenOption[] openOptionArray;
        if (overwrite) {
            openOptionArray = new OpenOption[]{};
        } else {
            OpenOption[] openOptionArray2 = new OpenOption[1];
            openOptionArray = openOptionArray2;
            openOptionArray2[0] = StandardOpenOption.CREATE_NEW;
        }
        OpenOption[] options = openOptionArray;
        try {
            Files.write(new File(filename).toPath(), contents, options);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to write content to file. ", e);
            return false;
        }
        return true;
    }

    public static boolean isFileExists(String file) {
        return Files.exists(new File(file).toPath(), new LinkOption[0]);
    }

    public static byte[] readFromFile(String filename) {
        byte[] res;
        Path path = new File(filename).toPath();
        try {
            res = Files.readAllBytes(path);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read from file. ", e);
            res = new byte[]{};
        }
        return res;
    }

    public static boolean createDirectory(String directory) {
        return new File(directory).mkdirs();
    }

    public static boolean isDirectoryExists(String directory) {
        return Files.isDirectory(new File(directory).toPath(), new LinkOption[0]);
    }

    public static boolean hasChildren(String file) {
        return FileUtils.isDirectoryExists(file) && new File(file).list().length > 0;
    }

    public static boolean deleteFile(String filename) {
        Path file = new File(filename).toPath();
        try {
            Files.delete(file);
        }
        catch (NoSuchFileException x) {
            LOG.severe("file does not exist: " + file);
            return false;
        }
        catch (DirectoryNotEmptyException x) {
            LOG.severe("Path is an not empty directory: " + file);
            return false;
        }
        catch (IOException x) {
            LOG.log(Level.SEVERE, "Failed to delete file due to unexpected exception:", x);
            return false;
        }
        return true;
    }

    public static void copyDirectoryToDirectory(String src, String dst) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectoryToDirectory((File)new File(src), (File)new File(dst));
    }

    public static void copyFileToDirectory(String src, String dstFolder) throws IOException {
        org.apache.commons.io.FileUtils.copyFileToDirectory((File)new File(src), (File)new File(dstFolder));
    }

    public static void copyDirectory(String src, String dst) throws IOException {
        org.apache.commons.io.FileUtils.copyDirectory((File)new File(src), (File)new File(dst));
    }

    public static boolean deleteDir(String dir) {
        try {
            org.apache.commons.io.FileUtils.deleteDirectory((File)new File(dir));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static String md5(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            String string = DigestUtils.md5Hex((InputStream)fis);
            return string;
        }
    }

    public static List<String> getDirectories(String dirName) {
        File dir = new File(dirName);
        if (dir.exists() && dir.isDirectory()) {
            File[] dirs = dir.listFiles(File::isDirectory);
            return Arrays.stream(dirs).map(f -> f.getName()).collect(Collectors.toList());
        }
        return new LinkedList<String>();
    }
}

