/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.scp;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.rsched.uploaders.scp.ScpContext;
import edu.iu.dsc.tws.rsched.uploaders.scp.ScpController;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ScpUploader
implements IUploader {
    private static final Logger LOG = Logger.getLogger(ScpUploader.class.getName());
    private String destinationDirectory;
    private ScpController controller;
    private Config config;

    protected ScpController getScpController() {
        String scpOptions = ScpContext.scpOptions(this.config);
        String scpConnection = ScpContext.scpConnection(this.config);
        String sshOptions = ScpContext.sshOptions(this.config);
        String sshConnection = ScpContext.sshConnection(this.config);
        if (scpOptions == null) {
            throw new RuntimeException("Missing twister2.resource.uploader.scp.command.options config value");
        }
        if (scpConnection == null) {
            throw new RuntimeException("Missing twister2.resource.uploader.scp.command.connection config value");
        }
        if (sshOptions == null) {
            throw new RuntimeException("Missing twister2.resource.uploader.ssh.command.options config value");
        }
        if (sshConnection == null) {
            throw new RuntimeException("Missing twister2.resource.uploader.ssh.command.connection config value");
        }
        return new ScpController(scpOptions, scpConnection, sshOptions, sshConnection);
    }

    public void initialize(Config conf, String jobID) {
        this.config = conf;
        this.controller = this.getScpController();
        this.destinationDirectory = ScpContext.uploaderJobDirectory(conf);
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        String source = sourceLocation + "/";
        File file = new File(source);
        String fileName = file.getName();
        boolean dirExist = file.isDirectory();
        if (!dirExist) {
            throw new UploaderException(String.format("Job package does not exist at '%s'", source));
        }
        LOG.log(Level.INFO, String.format("Uploading the file from local file system to remote machine: %s -> %s.", source, this.destinationDirectory));
        try {
            if (!this.controller.copyFromLocalDirectory(source, this.destinationDirectory)) {
                throw new UploaderException(String.format("Failed to upload the file from local file system to remote machine: %s -> %s.", source, this.destinationDirectory));
            }
            LOG.log(Level.INFO, String.format("Uploaded to remote machine: %s -> %s.", source, this.destinationDirectory));
            return new URI(this.destinationDirectory);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid file path for topology package destination: " + this.destinationDirectory, e);
        }
    }

    public boolean undo() {
        LOG.info("Clean uploaded jar");
        File file = new File(this.destinationDirectory);
        return file.delete();
    }

    public void close() {
    }
}

