/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.localfs;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.rsched.uploaders.localfs.FsContext;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalFileSystemUploader
implements IUploader {
    private static final Logger LOG = Logger.getLogger(LocalFileSystemUploader.class.getName());
    private String destinationDirectory;

    public void initialize(Config config, String jobID) {
        this.destinationDirectory = FsContext.uploaderJobDirectory(config) + "/" + jobID;
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        File file = new File(sourceLocation);
        boolean fileExists = file.isDirectory();
        if (!fileExists) {
            throw new UploaderException(String.format("Job package does not exist at '%s'", sourceLocation));
        }
        String directoryName = file.getName();
        Path filePath = Paths.get(this.destinationDirectory, new String[0]);
        File parentDirectory = filePath.toFile();
        assert (parentDirectory != null);
        if (!parentDirectory.exists()) {
            LOG.log(Level.FINE, String.format("Target directory does not exist. Creating it now at %s", parentDirectory.getPath()));
            if (!parentDirectory.mkdirs()) {
                throw new UploaderException(String.format("Failed to create directory for topology package at %s", parentDirectory.getPath()));
            }
        }
        if (fileExists = new File(filePath.toString()).isFile()) {
            LOG.fine(String.format("Target job package already exists at '%s'. Overwriting it now", filePath.toString()));
        }
        LOG.log(Level.FINE, String.format("Copying job directory at '%s' to target directory '%s'", sourceLocation, filePath.toString()));
        try {
            FileUtils.copyDirectory(sourceLocation, this.destinationDirectory);
            return new URI(this.destinationDirectory);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid file path for topology package destination: " + this.destinationDirectory, e);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to copy directory %s to %s", sourceLocation, this.destinationDirectory));
        }
    }

    public boolean undo() {
        LOG.info("Cleaning upload directory: " + this.destinationDirectory);
        return FileUtils.deleteDir(this.destinationDirectory);
    }

    public void close() {
    }
}

