/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.k8s;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.uploaders.k8s.UploaderToPod;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploaderToWebServers
extends Thread
implements IUploader {
    private static final Logger LOG = Logger.getLogger(UploaderToWebServers.class.getName());
    private Config config;
    private String jobID;
    private String localJobPackageFile;
    private String namespace;
    private ArrayList<UploaderToPod> uploadersToWebServers = new ArrayList();
    private List<String> webServerPodNames;

    public UploaderToWebServers(List<String> webServerPodNames) {
        this.webServerPodNames = webServerPodNames;
    }

    public void initialize(Config cnfg, String jbID) {
        this.config = cnfg;
        this.jobID = jbID;
        this.namespace = KubernetesContext.namespace(this.config);
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        this.localJobPackageFile = sourceLocation + File.separator + SchedulerContext.jobPackageFileName((Config)this.config);
        this.start();
        if (CheckpointingContext.startingFromACheckpoint((Config)this.config)) {
            while (this.webServerPodNames.size() != this.uploadersToWebServers.size()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
            }
            LOG.fine("Wait uploading to web servers to finish ...");
            this.complete();
            LOG.info("Uploading to web servers finished ...");
        }
        String uri = KubernetesContext.uploaderWebServer(this.config) + "/" + JobUtils.createJobPackageFileName(this.jobID);
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            LOG.log(Level.SEVERE, "Can not generate URI for uploader web server: " + uri, e);
            throw new UploaderException("Can not generate URI for download link: " + uri, (Throwable)e);
        }
    }

    @Override
    public void run() {
        String targetFile = KubernetesUtils.jobPackageFullPath(this.config, this.jobID);
        for (String webServerPodName : this.webServerPodNames) {
            UploaderToPod uploader = new UploaderToPod(this.namespace, webServerPodName, this.localJobPackageFile, targetFile);
            uploader.start();
            this.uploadersToWebServers.add(uploader);
        }
    }

    public boolean complete() {
        boolean allTransferred = true;
        for (UploaderToPod uploader : this.uploadersToWebServers) {
            try {
                uploader.join();
                if (uploader.packageTransferred()) continue;
                LOG.log(Level.SEVERE, "Job Package is not transferred to the web server pod: " + uploader.getPodName());
                allTransferred = false;
                break;
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, "Thread sleep interrupted.", e);
            }
        }
        if (!allTransferred) {
            for (UploaderToPod uploader : this.uploadersToWebServers) {
                uploader.cancelTransfer();
            }
        }
        return allTransferred;
    }

    public boolean undo() {
        String jobPackageFile = KubernetesUtils.jobPackageFullPath(this.config, this.jobID);
        KubernetesController controller = KubernetesController.init(KubernetesContext.namespace(this.config));
        return controller.deleteJobPackage(this.webServerPodNames, jobPackageFile);
    }

    public void close() {
    }
}

