/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.MPIContext;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPICommand;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;

public class StandaloneCommand
extends MPICommand {
    private static final Logger LOG = Logger.getLogger(StandaloneCommand.class.getName());

    public StandaloneCommand(Config cfg, String workingDirectory) {
        super(cfg, workingDirectory);
    }

    @Override
    protected String[] killCommand() {
        return new String[0];
    }

    @Override
    public String[] mpiCommand(String workingDir, JobAPI.Job job) {
        String twister2Home = Paths.get(workingDir, job.getJobId()).toString();
        String confDir = Paths.get(workingDir, job.getJobId(), SchedulerContext.clusterType((Config)this.config)).toString();
        String hostfile = Paths.get(confDir, MPIContext.nodesFile((Config)this.config)).toString();
        String[] mpirunCmd = new String[]{this.mpirunPath(), "-np", this.getNumberOfWorkers(job), "--map-by", this.getMapBy(job), "--hostfile", hostfile, "-x", "LD_LIBRARY_PATH=" + this.ldLibraryPath(), "-x", "XMX_VALUE=" + this.getMemory(job) + "m", "-x", "XMS_VALUE=" + this.getMemory(job) + "m", "-x", "SUBMITTING_TWISTER2_HOME=" + this.submittingTwister2Home(), "-x", "CLASSPATH=" + this.getClasspath(this.config, job), "-x", "ILLEGAL_ACCESS_WARN=" + this.illegalAccessWarn(), "-x", "DEBUG=" + this.getDebug(), "-x", "JOB_ID=" + job.getJobId(), "-x", "TWISTER2_HOME=" + twister2Home, "-x", "CONFIG_DIR=" + twister2Home, "-x", "JOB_MASTER_IP=" + this.config.getStringValue("__job_master_ip__", "ip"), "-x", "JOB_MASTER_PORT=" + this.config.getIntegerValue("__job_master_port__", 0) + "", "-x", "RESTORE_JOB= " + CheckpointingContext.startingFromACheckpoint((Config)this.config)};
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.addAll(Arrays.asList(mpirunCmd));
        String mpiParams = MPIContext.mpiParams((Config)this.config);
        if (mpiParams != null && !mpiParams.trim().isEmpty()) {
            cmdList.addAll(Arrays.asList(mpiParams.split(" ")));
        }
        cmdList.add("-x");
        cmdList.add("RESTART_COUNT=0");
        cmdList.add(MPIContext.mpiScriptWithPath((Config)this.config));
        return cmdList.toArray(new String[0]);
    }

    private String getDebug() {
        if (this.config.getBooleanValue("debug", false).booleanValue()) {
            return "debug";
        }
        return "no-debug";
    }

    protected String illegalAccessWarn() {
        if (StandaloneCommand.getJavaVersion() >= 9) {
            return "suppress_illegal_access_warn";
        }
        return "allow_illegal_access_warn";
    }

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        LOG.info("Java version : " + version);
        return Integer.parseInt(version);
    }

    @Override
    protected void updateRestartCount(String[] cmd, int restartCount) {
        cmd[cmd.length - 2] = "RESTART_COUNT=" + restartCount;
    }
}

