/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.MPIContext;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.standalone.MPICommand;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SlurmCommand
extends MPICommand {
    private static final Logger LOG = Logger.getLogger(SlurmCommand.class.getName());
    private String jobIdFile = this.getJobIdFilePath();

    public SlurmCommand(Config cfg, String workingDirectory) {
        super(cfg, workingDirectory);
    }

    @Override
    protected String[] killCommand() {
        String file = this.getJobIdFilePath();
        List<String> jobIdFileContent = this.readFromFile(file);
        if (jobIdFileContent.size() > 0) {
            return new String[]{"scancel", jobIdFileContent.get(0)};
        }
        LOG.log(Level.SEVERE, "Failed to read the Slurm Job id from file: {0}", this.jobIdFile);
        return null;
    }

    @Override
    public String[] mpiCommand(String workingDir, JobAPI.Job job) {
        String twister2Home = Paths.get(workingDir, job.getJobId()).toString();
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("sbatch");
        cmd.add("--partition=" + MPIContext.partition((Config)this.config));
        String slurmParams = MPIContext.slurmParams((Config)this.config);
        if (slurmParams != null && !slurmParams.trim().isEmpty()) {
            cmd.addAll(Arrays.asList(slurmParams.split(" ")));
        }
        cmd.add(this.mpirunPath());
        String mpiParams = MPIContext.mpiParams((Config)this.config);
        if (mpiParams != null && !mpiParams.trim().isEmpty()) {
            cmd.addAll(Arrays.asList(mpiParams.split(" ")));
        }
        cmd.add("java");
        cmd.add("-Xmx" + this.getMemory(job) + "m");
        cmd.add("-Xms" + this.getMemory(job) + "m");
        cmd.add("-Djava.util.logging.config.file=common/logger.properties");
        cmd.add("-cp");
        cmd.add(this.getClasspath(this.config, job));
        cmd.add("edu.iu.dsc.tws.rsched.schedulers.standalone.MPIWorkerStarter");
        cmd.add("--job_id");
        cmd.add(job.getJobId());
        cmd.add("--twister2_home");
        cmd.add(twister2Home);
        cmd.add("--config_dir");
        cmd.add(twister2Home);
        cmd.add("--cluster_type");
        cmd.add("slurm");
        cmd.add("--job_master_ip");
        cmd.add(this.config.getStringValue("__job_master_ip__", "ip"));
        cmd.add("--job_master_port");
        cmd.add(this.config.getIntegerValue("__job_master_port__", 0) + "");
        cmd.add("--restore_job");
        cmd.add(Boolean.toString(CheckpointingContext.startingFromACheckpoint((Config)this.config)));
        cmd.add("--restart_count");
        cmd.add("0");
        return cmd.toArray(new String[0]);
    }

    protected String getJobIdFilePath() {
        return new File(this.workingDirectory, MPIContext.jobIdFile((Config)this.config)).getPath();
    }

    @Override
    protected void updateRestartCount(String[] cmd, int restartCount) {
        cmd[cmd.length - 1] = "" + restartCount;
    }
}

