/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.nomad;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.driver.NullScaler;
import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.common.logging.LoggingHelper;
import edu.iu.dsc.tws.common.zk.ZKJobMasterRegistrar;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.NullTerminator;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadContext;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadController;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadPersistentVolume;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import edu.iu.dsc.tws.rsched.utils.ResourceSchedulerUtils;
import java.io.File;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class NomadJobMasterStarter {
    private static final Logger LOG = Logger.getLogger(NomadJobMasterStarter.class.getName());
    private JobAPI.Job job;
    private Config config;
    private NomadController controller;

    public NomadJobMasterStarter(String[] args) {
        Options cmdOptions = null;
        try {
            cmdOptions = this.setupOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(cmdOptions, args);
            int rank = 0;
            this.config = this.loadConfigurations(cmd, rank);
            this.controller = new NomadController(true);
            this.controller.initialize(this.config);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("SubmitterMain", cmdOptions);
            throw new RuntimeException("Error parsing command line options: ", e);
        }
    }

    private Options setupOptions() {
        Options options = new Options();
        Option containerClass = Option.builder((String)"c").desc("The class name of the container to launch").longOpt("container_class").hasArgs().argName("container class").required().build();
        Option configDirectory = Option.builder((String)"d").desc("The class name of the container to launch").longOpt("config_dir").hasArgs().argName("configuration directory").required().build();
        Option twister2Home = Option.builder((String)"t").desc("The class name of the container to launch").longOpt("twister2_home").hasArgs().argName("twister2 home").required().build();
        Option clusterType = Option.builder((String)"n").desc("The clustr type").longOpt("cluster_type").hasArgs().argName("cluster type").required().build();
        Option jobID = Option.builder((String)"j").desc("Job Id").longOpt("job_id").hasArgs().argName("job id").required().build();
        Option jobId = Option.builder((String)"i").desc("Job id").longOpt("job_id").hasArgs().argName("job id").required().build();
        options.addOption(twister2Home);
        options.addOption(containerClass);
        options.addOption(configDirectory);
        options.addOption(clusterType);
        options.addOption(jobID);
        options.addOption(jobId);
        return options;
    }

    private Config loadConfigurations(CommandLine cmd, int id) {
        String twister2Home = cmd.getOptionValue("twister2_home");
        String container = cmd.getOptionValue("container_class");
        String configDir = cmd.getOptionValue("config_dir");
        String clusterType = cmd.getOptionValue("cluster_type");
        String jobId = cmd.getOptionValue("job_id");
        LOG.log(Level.FINE, String.format("Initializing process with twister_home: %s container_class: %s config_dir: %s cluster_type: %s", twister2Home, container, configDir, clusterType));
        Config cfg = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)clusterType);
        Config workerConfig = Config.newBuilder().putAll(cfg).put(SchedulerContext.TWISTER2_HOME.getKey(), (Object)twister2Home).put("twister2.resource.job.worker.class", (Object)container).put("twister2.container.id", (Object)id).put("twister2.job.id", (Object)jobId).put("twister2.cluster.type", (Object)clusterType).build();
        String jobDescFile = JobUtils.getJobDescriptionFilePath(jobId, workerConfig);
        this.job = JobUtils.readJobFile(jobDescFile);
        this.job.getNumberOfWorkers();
        Config updatedConfig = JobUtils.overrideConfigs(this.job, cfg);
        updatedConfig = Config.newBuilder().putAll(updatedConfig).put(SchedulerContext.TWISTER2_HOME.getKey(), (Object)twister2Home).put("twister2.resource.job.worker.class", (Object)container).put("twister2.container.id", (Object)id).put("twister2.cluster.type", (Object)clusterType).put("twister2.job.id", (Object)jobId).put("twister2.resource.job.name", (Object)this.job.getJobName()).build();
        return updatedConfig;
    }

    public void initialize(JobAPI.Job jb, Config cfg) {
        this.job = jb;
        this.config = cfg;
    }

    public static void main(String[] args) {
        NomadJobMasterStarter starter = new NomadJobMasterStarter(args);
        starter.run();
    }

    public void run() {
        this.launch();
    }

    public boolean launch() {
        String indexEnv = System.getenv("NOMAD_ALLOC_INDEX");
        String idEnv = System.getenv("NOMAD_ALLOC_ID");
        int workerID = Integer.valueOf(indexEnv);
        this.initLogger(this.config, workerID);
        LOG.log(Level.INFO, String.format("Worker id = %s and index = %d", idEnv, workerID));
        ZKJobMasterRegistrar registrar = null;
        int port = JobMasterContext.jobMasterPort((Config)this.config);
        String hostAddress = null;
        try {
            hostAddress = Inet4Address.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        try {
            registrar = new ZKJobMasterRegistrar(this.config, hostAddress, port, this.job.getJobId());
            LOG.info("JobMaster REGISTERED..:" + hostAddress);
        }
        catch (Exception e) {
            LOG.info("JobMaster CAN NOT BE REGISTERED:");
            e.printStackTrace();
        }
        boolean initialized = registrar.initialize();
        if (!initialized) {
            LOG.info("CAN NOT INITIALIZE");
        }
        if (!initialized && registrar.sameZNodeExist()) {
            registrar.deleteJobMasterZNode();
            registrar.initialize();
        }
        JobMaster jobMaster = null;
        JobMasterAPI.NodeInfo jobMasterNodeInfo = NomadContext.getNodeInfo((Config)this.config, (String)hostAddress);
        NullScaler clusterScaler = new NullScaler();
        Object jmThread = null;
        int workerCount = this.job.getNumberOfWorkers();
        LOG.info("Worker Count..: " + workerCount);
        LOG.log(Level.INFO, String.format("Starting the Job Master: %s:%d", hostAddress, port));
        JobMasterAPI.JobMasterState initialState = JobMasterAPI.JobMasterState.JM_STARTED;
        NullTerminator nt = new NullTerminator();
        jobMaster = new JobMaster(this.config, hostAddress, (IJobTerminator)nt, this.job, jobMasterNodeInfo, (IScalerPerCluster)clusterScaler, initialState);
        jobMaster.addShutdownHook(true);
        try {
            jobMaster.startJobMasterBlocking();
        }
        catch (Twister2Exception e) {
            LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        NomadJobMasterStarter.waitIndefinitely();
        registrar.deleteJobMasterZNode();
        registrar.close();
        boolean start = this.controller.start(this.job);
        return start;
    }

    public static void waitIndefinitely() {
        while (true) {
            try {
                while (true) {
                    LOG.info("JobMasterStarter thread waiting indefinitely. Sleeping 100sec. Time: " + new Date());
                    Thread.sleep(100000L);
                }
            }
            catch (InterruptedException e) {
                LOG.warning("Thread sleep interrupted.");
                continue;
            }
            break;
        }
    }

    private boolean setupWorkingDirectory(JobAPI.Job jb, String jobWorkingDirectory) {
        String corePackage = NomadContext.corePackageFileName((Config)this.config);
        String jobPackage = NomadContext.jobPackageFileName((Config)this.config);
        LOG.log(Level.INFO, "Core Package is ......: " + corePackage);
        LOG.log(Level.INFO, "Job Package is ......: " + jobPackage);
        String jobPackageURI = NomadContext.jobPackageUri((Config)this.config).toString();
        LOG.log(Level.INFO, "Job Package URI is ......: " + jobPackageURI);
        return ResourceSchedulerUtils.setupWorkingDirectory(jb.getJobId(), jobWorkingDirectory, corePackage, jobPackageURI, Context.verbose((Config)this.config));
    }

    private void initLogger(Config cfg, int workerID) {
        LoggingHelper.setLoggingFormat((String)"[%1$tF %1$tT] [%4$s] [%7$s] %3$s: %5$s %6$s %n");
        String jobWorkingDirectory = NomadContext.workingDirectory(cfg);
        String jobID = NomadContext.jobId((Config)cfg);
        NomadPersistentVolume pv = new NomadPersistentVolume(this.controller.createPersistentJobDirName(jobID), workerID);
        String persistentJobDir = pv.getJobDir().getAbsolutePath();
        if (persistentJobDir == null) {
            return;
        }
        String logDir = persistentJobDir + "/logs";
        LOG.log(Level.INFO, "LOG DIR is ......: " + logDir);
        File directory = new File(logDir);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new RuntimeException("Failed to create log directory: " + logDir);
        }
        LoggingHelper.setupLogging((Config)cfg, (String)logDir, (String)("worker-" + workerID));
    }
}

