/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import com.google.gson.reflect.TypeToken;
import edu.iu.dsc.tws.master.server.JobMaster;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.util.Watch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.Call;

public class JobKillWatcher
extends Thread {
    private static final Logger LOG = Logger.getLogger(JobKillWatcher.class.getName());
    private String namespace;
    private String jobID;
    private KubernetesController controller;
    private JobMaster jobMaster;
    private Watch<V1ConfigMap> watcher = null;
    private boolean stopWatcher = false;

    public JobKillWatcher(String namespace, String jobID, KubernetesController controller, JobMaster jobMaster) {
        this.namespace = namespace;
        this.jobID = jobID;
        this.controller = controller;
        this.jobMaster = jobMaster;
    }

    @Override
    public void run() {
        String killParam = "KILL_JOB";
        String cmName = this.jobID;
        String labelSelector = KubernetesUtils.jobLabelSelector(this.jobID);
        Integer timeoutSeconds = Integer.MAX_VALUE;
        JobKillWatcher jobKillWatcher = this;
        CoreV1Api v1Api = jobKillWatcher.controller.createCoreV1Api();
        try {
            JobKillWatcher jobKillWatcher2 = this;
            this.watcher = Watch.createWatch((ApiClient)jobKillWatcher2.controller.getApiClient(), (Call)v1Api.listNamespacedConfigMapCall(this.namespace, null, null, null, null, labelSelector, null, null, timeoutSeconds, Boolean.TRUE, null), (Type)new TypeToken<Watch.Response<V1ConfigMap>>(){}.getType());
        }
        catch (ApiException e) {
            String logMessage = "Exception when watching the ConfigMap: \nexCode: " + e.getCode() + "\nresponseBody: " + e.getResponseBody();
            LOG.log(Level.SEVERE, logMessage, e);
            throw new RuntimeException(e);
        }
        try {
            for (Watch.Response item : this.watcher) {
                if (item.object == null || ((V1ConfigMap)item.object).getData() == null || !((V1ConfigMap)item.object).getMetadata().getName().equals(cmName) || ((V1ConfigMap)item.object).getData().get(killParam) == null) continue;
                LOG.info("Job Kill parameter received. Killing the job");
                this.jobMaster.endJob(JobAPI.JobState.KILLED);
                return;
            }
        }
        catch (RuntimeException e) {
            if (this.stopWatcher) {
                LOG.fine("Watcher is stopped.");
                return;
            }
            throw e;
        }
        finally {
            try {
                this.watcher.close();
            }
            catch (IOException e) {
                LOG.warning("IOException when closing ConfigMapWatcher");
            }
        }
    }

    public void close() {
        if (this.watcher == null) {
            return;
        }
        this.stopWatcher = true;
        try {
            this.watcher.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

