/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.driver;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.driver.IScalerPerCluster;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.common.zk.ZKContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.JobUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import java.util.logging.Logger;

public class K8sScaler
implements IScalerPerCluster {
    private static final Logger LOG = Logger.getLogger(K8sScaler.class.getName());
    private Config config;
    private KubernetesController k8sController;
    private String jobID;
    private JobAPI.Job job;
    private String scalableSSName;
    private int replicas;
    private int workersPerPod;
    private boolean scalable;

    public K8sScaler(Config config, JobAPI.Job job, KubernetesController k8sController) {
        this.k8sController = k8sController;
        this.config = config;
        this.job = job;
        this.jobID = job.getJobId();
        int computeResourceIndex = job.getComputeResourceCount() - 1;
        JobAPI.ComputeResource scalableCompRes = job.getComputeResource(computeResourceIndex);
        this.replicas = scalableCompRes.getInstances();
        this.workersPerPod = scalableCompRes.getWorkersPerPod();
        this.scalable = scalableCompRes.getScalable();
        this.scalableSSName = KubernetesUtils.createWorkersStatefulSetName(job.getJobId(), computeResourceIndex);
    }

    public boolean isScalable() {
        if (!this.scalable) {
            return false;
        }
        return !SchedulerContext.useOpenMPI((Config)this.config);
    }

    public boolean scaleUpWorkers(int instancesToAdd) {
        if (instancesToAdd % this.workersPerPod != 0) {
            LOG.severe("instancesToAdd has to be a multiple of workersPerPod=" + this.workersPerPod);
            return false;
        }
        int podsToAdd = instancesToAdd / this.workersPerPod;
        boolean scaledUp = this.k8sController.patchStatefulSet(this.scalableSSName, this.replicas + podsToAdd);
        if (!scaledUp) {
            return false;
        }
        this.updateConfigMap(instancesToAdd);
        this.replicas += podsToAdd;
        return true;
    }

    public boolean scaleDownWorkers(int instancesToRemove, int numberOfWorkers) {
        if (instancesToRemove % this.workersPerPod != 0) {
            LOG.severe("instancesToRemove has to be a multiple of workersPerPod=" + this.workersPerPod);
            return false;
        }
        int podsToRemove = instancesToRemove / this.workersPerPod;
        if (podsToRemove > this.replicas) {
            LOG.severe(String.format("There are %d instances of scalable ComputeResource, and %d instances requested to be removed", this.replicas, podsToRemove));
            return false;
        }
        boolean scaledDown = this.k8sController.patchStatefulSet(this.scalableSSName, this.replicas - podsToRemove);
        if (!scaledDown) {
            return false;
        }
        this.updateConfigMap(0 - instancesToRemove);
        if (!ZKContext.isZooKeeperServerUsed((Config)this.config)) {
            for (int wID = numberOfWorkers - instancesToRemove; wID < numberOfWorkers; ++wID) {
                String keyName = KubernetesUtils.createRestartWorkerKey(wID);
                boolean removed = this.k8sController.removeRestartCount(this.jobID, keyName);
                if (removed) continue;
                return false;
            }
        }
        this.replicas -= podsToRemove;
        return true;
    }

    private void updateConfigMap(int workerChange) {
        this.job = JobUtils.scaleJob((JobAPI.Job)this.job, (int)workerChange);
        boolean cmUpdated = this.k8sController.updateConfigMapJobParam(this.job);
        if (!cmUpdated) {
            throw new Twister2RuntimeException("Can not update job object at ConfigMap");
        }
    }
}

