/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s;

import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.NodeInfoUtils;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import io.kubernetes.client.Exec;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.AppsV1Api;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1ConfigMap;
import io.kubernetes.client.openapi.models.V1ConfigMapList;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1PersistentVolume;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaim;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimList;
import io.kubernetes.client.openapi.models.V1PersistentVolumeList;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1SecretList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.openapi.models.V1StatefulSet;
import io.kubernetes.client.openapi.models.V1StatefulSetList;
import io.kubernetes.client.util.ClientBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Response;

public final class KubernetesController {
    private static final Logger LOG = Logger.getLogger(KubernetesController.class.getName());
    private static String namespace;
    private static ApiClient client;
    private static CoreV1Api coreApi;
    private static AppsV1Api appsApi;
    private static KubernetesController controller;

    private KubernetesController() {
    }

    public static synchronized KubernetesController init(String nspace) {
        if (controller != null) {
            return controller;
        }
        namespace = nspace;
        KubernetesController.initApiInstances();
        controller = new KubernetesController();
        return controller;
    }

    public static ApiClient getApiClient() {
        if (client != null) {
            return client;
        }
        try {
            client = ClientBuilder.standard().setOverridePatchFormat("application/json-patch+json").build();
            return client;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating ApiClient: ", e);
            throw new RuntimeException(e);
        }
    }

    private static void initApiInstances() {
        if (client == null) {
            KubernetesController.getApiClient();
        }
        Configuration.setDefaultApiClient((ApiClient)client);
        coreApi = new CoreV1Api();
        appsApi = new AppsV1Api(client);
    }

    public static CoreV1Api createCoreV1Api() {
        if (client == null) {
            KubernetesController.getApiClient();
        }
        OkHttpClient httpClient = client.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build();
        client.setHttpClient(httpClient);
        Configuration.setDefaultApiClient((ApiClient)client);
        return new CoreV1Api(client);
    }

    public static void close() {
        if (client != null && client.getHttpClient() != null && client.getHttpClient().dispatcher() != null && client.getHttpClient().dispatcher().executorService() != null) {
            client.getHttpClient().dispatcher().executorService().shutdown();
        }
        if (client != null && client.getHttpClient() != null && client.getHttpClient().connectionPool() != null) {
            client.getHttpClient().connectionPool().evictAll();
        }
        if (client != null && client.getHttpClient() != null && client.getHttpClient().cache() != null) {
            try {
                client.getHttpClient().cache().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        controller = null;
    }

    public List<V1StatefulSet> getJobStatefulSets(String jobID) {
        String labelSelector = KubernetesUtils.jobLabelSelector(jobID);
        try {
            V1StatefulSetList setList = appsApi.listNamespacedStatefulSet(namespace, null, null, null, null, labelSelector, null, null, null, null);
            return setList.getItems();
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting StatefulSet list.", e);
            throw new RuntimeException(e);
        }
    }

    public boolean existStatefulSets(List<String> statefulSetNames) {
        V1StatefulSetList setList = null;
        try {
            setList = appsApi.listNamespacedStatefulSet(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting StatefulSet list.", e);
            throw new RuntimeException(e);
        }
        for (V1StatefulSet statefulSet : setList.getItems()) {
            if (!statefulSetNames.contains(statefulSet.getMetadata().getName())) continue;
            LOG.severe("There is already a StatefulSet with the name: " + statefulSet.getMetadata().getName());
            return true;
        }
        return false;
    }

    public ArrayList<String> getJobWorkerStatefulSets(String jobID) {
        List<V1StatefulSet> ssList = this.getJobStatefulSets(jobID);
        ArrayList<String> ssNameList = new ArrayList<String>();
        for (V1StatefulSet statefulSet : ssList) {
            String ssName = statefulSet.getMetadata().getName();
            if (!ssName.matches(jobID + "-[0-9]+")) continue;
            ssNameList.add(ssName);
        }
        return ssNameList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createStatefulSet(V1StatefulSet statefulSet) {
        String statefulSetName = statefulSet.getMetadata().getName();
        try (Response response = appsApi.createNamespacedStatefulSetCall(namespace, statefulSet, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + statefulSetName + "] is created.");
                boolean bl2 = true;
                return bl2;
            }
            LOG.log(Level.SEVERE, "Error when creating the StatefulSet [" + statefulSetName + "]: " + response);
            LOG.log(Level.SEVERE, "Submitted StatefulSet Object: " + statefulSet);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the StatefulSet: " + statefulSetName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the StatefulSet: " + statefulSetName, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteStatefulSet(String statefulSetName) {
        Integer gracePeriodSeconds = 0;
        try (Response response = appsApi.deleteNamespacedStatefulSetCall(statefulSetName, namespace, null, null, gracePeriodSeconds, null, "Foreground", null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + statefulSetName + "] is deleted.");
                boolean bl = true;
                return bl;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.SEVERE, "There is no StatefulSet [" + statefulSetName + "] to delete on Kubernetes master. It may have already terminated.");
                boolean bl = true;
                return bl;
            }
            LOG.log(Level.SEVERE, "Error when deleting the StatefulSet [" + statefulSetName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the StatefulSet: " + statefulSetName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the StatefulSet: " + statefulSetName, e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean patchStatefulSet(String ssName, int replicas) {
        String jsonPatchStr = "[{\"op\":\"replace\",\"path\":\"/spec/replicas\",\"value\":" + replicas + "}]";
        try (Response response = appsApi.patchNamespacedStatefulSetScaleCall(ssName, namespace, (Object)new V1Patch(jsonPatchStr), null, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "StatefulSet [" + ssName + "] is patched.");
                boolean bl2 = true;
                return bl2;
            }
            LOG.log(Level.SEVERE, "Error when patching the StatefulSet [" + ssName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + ssName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + ssName, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createService(V1Service service) {
        String serviceName = service.getMetadata().getName();
        try (Response response = coreApi.createNamespacedServiceCall(namespace, service, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "Service [" + serviceName + "] created.");
                boolean bl2 = true;
                return bl2;
            }
            LOG.log(Level.SEVERE, "Error when creating the service [" + serviceName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the service: " + serviceName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the service: " + serviceName, e);
        }
        return false;
    }

    public List<V1Service> getJobServices(String jobID) {
        String labelSelector = KubernetesUtils.jobLabelSelector(jobID);
        try {
            V1ServiceList serviceList = coreApi.listNamespacedService(namespace, null, null, null, null, labelSelector, null, null, null, null);
            return serviceList.getItems();
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
    }

    public String existServices(List<String> serviceNames) {
        V1ServiceList serviceList = null;
        try {
            serviceList = coreApi.listNamespacedService(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
        for (V1Service service : serviceList.getItems()) {
            if (!serviceNames.contains(service.getMetadata().getName())) continue;
            return service.getMetadata().getName();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteService(String serviceName) {
        Integer gracePeriodsSeconds = 0;
        try (Response response = coreApi.deleteNamespacedServiceCall(serviceName, namespace, null, null, gracePeriodsSeconds, null, "Foreground", null, null).execute();){
            if (response.isSuccessful()) {
                LOG.info("Service [" + serviceName + "] is deleted.");
                boolean bl = true;
                return bl;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.warning("There is no Service [" + serviceName + "] to delete on Kubernetes master. It may have already been terminated.");
                boolean bl = true;
                return bl;
            }
            LOG.severe("Error when deleting the Service [" + serviceName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the service: " + serviceName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the service: " + serviceName, e);
            return false;
        }
    }

    public String getServiceIP(String serviceName) {
        V1ServiceList serviceList = null;
        try {
            serviceList = coreApi.listNamespacedService(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting service list.", e);
            throw new RuntimeException(e);
        }
        for (V1Service service : serviceList.getItems()) {
            if (!serviceName.equals(service.getMetadata().getName())) continue;
            return service.getSpec().getClusterIP();
        }
        return null;
    }

    public static boolean runProcess(String[] command) {
        StringBuilder stderr = new StringBuilder();
        int status = ProcessUtils.runSyncProcess(false, command, stderr, new File("."), false);
        return status == 0;
    }

    public boolean existPersistentVolumeClaim(String jobID) {
        String pvcName = jobID;
        V1PersistentVolumeClaimList pvcList = null;
        try {
            pvcList = coreApi.listNamespacedPersistentVolumeClaim(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolumeClaim list.", e);
            throw new RuntimeException(e);
        }
        for (V1PersistentVolumeClaim pvc : pvcList.getItems()) {
            if (!pvcName.equals(pvc.getMetadata().getName())) continue;
            LOG.severe("There is already a PersistentVolumeClaim with the name: " + pvcName);
            return true;
        }
        return false;
    }

    public V1PersistentVolumeClaim getJobPersistentVolumeClaim(String jobID) {
        String labelSelector = KubernetesUtils.jobLabelSelector(jobID);
        try {
            V1PersistentVolumeClaimList pvcList = coreApi.listNamespacedPersistentVolumeClaim(namespace, null, null, null, null, labelSelector, null, null, null, null);
            if (pvcList.getItems().size() == 1) {
                return (V1PersistentVolumeClaim)pvcList.getItems().get(0);
            }
            if (pvcList.getItems().size() > 1) {
                throw new Twister2RuntimeException("There are multiple PersistentVolumeClaim objects for this job on Kubernetes master");
            }
            return null;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolumeClaim list.", e);
            throw new RuntimeException(e);
        }
    }

    public List<String> getTwister2PersistentVolumeClaims() {
        String labelSelector = KubernetesUtils.twister2LabelSelector();
        try {
            V1PersistentVolumeClaimList pvcList = coreApi.listNamespacedPersistentVolumeClaim(namespace, null, null, null, null, labelSelector, null, null, null, null);
            return pvcList.getItems().stream().map(pvc -> pvc.getMetadata().getName()).collect(Collectors.toList());
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolumeClaim list.", e);
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createPersistentVolumeClaim(V1PersistentVolumeClaim pvc) {
        String pvcName = pvc.getMetadata().getName();
        try (Response response = coreApi.createNamespacedPersistentVolumeClaimCall(namespace, pvc, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolumeClaim [" + pvcName + "] is created.");
                boolean bl2 = true;
                return bl2;
            }
            LOG.log(Level.SEVERE, "Error when creating the PersistentVolumeClaim [" + pvcName + "] Response: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolumeClaim: " + pvcName, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deletePersistentVolumeClaim(String jobID) {
        String pvcName = jobID;
        try (Response response = coreApi.deleteNamespacedPersistentVolumeClaimCall(pvcName, namespace, null, null, null, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolumeClaim [" + pvcName + "] is deleted.");
                boolean bl = true;
                return bl;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.FINE, "There is no PersistentVolumeClaim [" + pvcName + "] to delete on Kubernetes master. It may have already been deleted.");
                boolean bl = true;
                return bl;
            }
            LOG.log(Level.SEVERE, "Error when deleting the PersistentVolumeClaim [" + pvcName + "] Response: " + response);
            boolean bl = false;
            return bl;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolumeClaim: " + pvcName, e);
            return false;
        }
    }

    public V1PersistentVolume getPersistentVolume(String pvName) {
        V1PersistentVolumeList pvList = null;
        try {
            pvList = coreApi.listPersistentVolume(null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting PersistentVolume list.", e);
            throw new RuntimeException(e);
        }
        for (V1PersistentVolume pv : pvList.getItems()) {
            if (!pvName.equals(pv.getMetadata().getName())) continue;
            return pv;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createPersistentVolume(V1PersistentVolume pv) {
        String pvName = pv.getMetadata().getName();
        try (Response response = coreApi.createPersistentVolumeCall(pv, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolume [" + pvName + "] is created.");
                boolean bl2 = true;
                return bl2;
            }
            LOG.log(Level.SEVERE, "Error when creating the PersistentVolume [" + pvName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolume: " + pvName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the PersistentVolume: " + pvName, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deletePersistentVolume(String pvName) {
        try (Response response = coreApi.deletePersistentVolumeCall(pvName, null, null, null, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "PersistentVolume [" + pvName + "] is deleted.");
                boolean bl = true;
                return bl;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.log(Level.WARNING, "There is no PersistentVolume [" + pvName + "] to delete on Kubernetes master. It may have already been deleted.");
                boolean bl = true;
                return bl;
            }
            LOG.log(Level.SEVERE, "Error when deleting the PersistentVolume [" + pvName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolume: " + pvName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the PersistentVolume: " + pvName, e);
            return false;
        }
    }

    public boolean existSecret(String secretName) {
        V1SecretList secretList = null;
        try {
            secretList = coreApi.listNamespacedSecret(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting Secret list.", e);
            throw new RuntimeException(e);
        }
        for (V1Secret secret : secretList.getItems()) {
            if (!secretName.equalsIgnoreCase(secret.getMetadata().getName())) continue;
            return true;
        }
        return false;
    }

    public ArrayList<JobMasterAPI.NodeInfo> getNodeInfo(String rackLabelKey, String datacenterLabelKey) {
        V1NodeList nodeList = null;
        try {
            nodeList = coreApi.listNode(null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting NodeList.", e);
            return null;
        }
        ArrayList<JobMasterAPI.NodeInfo> nodeInfoList = new ArrayList<JobMasterAPI.NodeInfo>();
        block2: for (V1Node node : nodeList.getItems()) {
            List addressList = node.getStatus().getAddresses();
            for (V1NodeAddress nodeAddress : addressList) {
                if (!"InternalIP".equalsIgnoreCase(nodeAddress.getType())) continue;
                String nodeIP = nodeAddress.getAddress();
                String rackName = null;
                String datacenterName = null;
                Map labelMap = node.getMetadata().getLabels();
                for (String key : labelMap.keySet()) {
                    if (key.equalsIgnoreCase(rackLabelKey)) {
                        rackName = (String)labelMap.get(key);
                    }
                    if (!key.equalsIgnoreCase(datacenterLabelKey)) continue;
                    datacenterName = (String)labelMap.get(key);
                }
                JobMasterAPI.NodeInfo nodeInfo = NodeInfoUtils.createNodeInfo((String)nodeIP, rackName, datacenterName);
                nodeInfoList.add(nodeInfo);
                continue block2;
            }
        }
        return nodeInfoList;
    }

    public List<String> getUploaderWebServerPods(String uploaderLabel) {
        V1PodList podList = null;
        try {
            podList = coreApi.listNamespacedPod(namespace, null, null, null, null, uploaderLabel, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting uploader pod list.", e);
            throw new RuntimeException(e);
        }
        List<String> podNames = podList.getItems().stream().map(v1pod -> v1pod.getMetadata().getName()).collect(Collectors.toList());
        return podNames;
    }

    public boolean deleteJobPackage(List<String> uploaderPods, String jobPackageName) {
        String command = String.format("rm %s", jobPackageName);
        String[] fullCommand = new String[]{"bash", "-c", command};
        boolean allDeleted = true;
        for (String uploaderPod : uploaderPods) {
            try {
                Exec exec = new Exec(KubernetesController.getApiClient());
                Process proc = exec.exec(namespace, uploaderPod, fullCommand, false, false);
                proc.waitFor();
                proc.destroy();
                if (proc.exitValue() == 0) {
                    LOG.info("Deleted job package from uploader web server pod: " + uploaderPod);
                    continue;
                }
                LOG.info("Could not delete the job package from uploader web server pod: " + uploaderPod + ", process exit code: " + proc.exitValue());
                allDeleted = false;
            }
            catch (ApiException e) {
                LOG.log(Level.INFO, String.format("Exception when deleting the job package from uploader web server [%s]", uploaderPod), e);
            }
            catch (IOException e) {
                LOG.log(Level.INFO, String.format("Exception when deleting the job package from uploader web server [%s]", uploaderPod), e);
            }
            catch (InterruptedException e) {
                LOG.log(Level.INFO, String.format("Exception when deleting the job package from uploader web server [%s]", uploaderPod), e);
            }
        }
        return allDeleted;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createConfigMap(V1ConfigMap configMap) {
        String configMapName = configMap.getMetadata().getName();
        try (Response response = coreApi.createNamespacedConfigMapCall(namespace, configMap, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.log(Level.INFO, "ConfigMap [" + configMapName + "] is created.");
                boolean bl2 = true;
                return bl2;
            }
            LOG.log(Level.SEVERE, "Error when creating the ConfigMap [" + configMapName + "]: Response: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when creating the ConfigMap: " + configMapName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when creating the ConfigMap: " + configMapName, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteConfigMap(String jobID) {
        String configMapName = jobID;
        int gracePeriodSeconds = 0;
        String propagationPolicy = "Foreground";
        try (Response response = coreApi.deleteNamespacedConfigMapCall(configMapName, namespace, null, null, Integer.valueOf(gracePeriodSeconds), null, propagationPolicy, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.info("ConfigMap [" + configMapName + "] is deleted.");
                boolean bl = true;
                return bl;
            }
            if (response.code() == 404 && response.message().equals("Not Found")) {
                LOG.warning("There is no ConfigMap [" + configMapName + "] to delete on Kubernetes master. It may have already been deleted.");
                boolean bl = true;
                return bl;
            }
            LOG.severe("Error when deleting the ConfigMap [" + configMapName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the ConfigMap: " + configMapName, e);
            return false;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when deleting the ConfigMap: " + configMapName, e);
        }
        return false;
    }

    public boolean existConfigMap(String jobID) {
        String configMapName = jobID;
        V1ConfigMapList configMapList = null;
        try {
            configMapList = coreApi.listNamespacedConfigMap(namespace, null, null, null, null, null, null, null, null, null);
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting ConfigMap list.", e);
            throw new RuntimeException(e);
        }
        for (V1ConfigMap configMap : configMapList.getItems()) {
            if (!configMapName.equals(configMap.getMetadata().getName())) continue;
            return true;
        }
        return false;
    }

    public List<String> getTwister2ConfigMapNames() {
        String labelSelector = KubernetesUtils.twister2LabelSelector();
        try {
            V1ConfigMapList configMapList = coreApi.listNamespacedConfigMap(namespace, null, null, null, null, labelSelector, null, null, null, null);
            return configMapList.getItems().stream().map(cm -> cm.getMetadata().getName()).collect(Collectors.toList());
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting ConfigMap list.", e);
            throw new RuntimeException(e);
        }
    }

    public V1ConfigMap getJobConfigMap(String jobID) {
        String labelSelector = KubernetesUtils.jobLabelSelector(jobID);
        try {
            V1ConfigMapList configMapList = coreApi.listNamespacedConfigMap(namespace, null, null, null, null, labelSelector, null, null, null, null);
            if (configMapList.getItems().size() == 1) {
                return (V1ConfigMap)configMapList.getItems().get(0);
            }
            if (configMapList.getItems().size() > 1) {
                throw new Twister2RuntimeException("There are multiple ConfigMaps for this job on Kubernetes master.");
            }
            return null;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when getting ConfigMap list.", e);
            throw new RuntimeException(e);
        }
    }

    public String getConfigMapParam(String jobID, String keyName) {
        Map<String, String> pairs = this.getConfigMapParams(jobID);
        return pairs.get(keyName);
    }

    public Map<String, String> getConfigMapParams(String jobID) {
        String configMapName = jobID;
        V1ConfigMap configMap = this.getJobConfigMap(jobID);
        if (configMap == null) {
            throw new RuntimeException("Could not get ConfigMap from K8s master: " + configMapName);
        }
        Map pairs = configMap.getData();
        if (pairs == null) {
            throw new RuntimeException("Could not get data from ConfigMap");
        }
        return pairs;
    }

    public int getRestartCount(String jobID, String keyName) {
        String countStr = this.getConfigMapParam(jobID, keyName);
        if (countStr == null) {
            return -1;
        }
        return Integer.parseInt(countStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addConfigMapParam(String jobID, String keyName, String value) {
        String configMapName = jobID;
        String valueStr = "\"" + value + "\"";
        String jsonPatchStr = "[{\"op\":\"add\",\"path\":\"/data/" + keyName + "\",\"value\":" + valueStr + "}]";
        try (Response response = coreApi.patchNamespacedConfigMapCall(configMapName, namespace, (Object)new V1Patch(jsonPatchStr), null, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.fine("ConfigMap parameter added " + keyName + " = " + value);
                boolean bl2 = true;
                return bl2;
            }
            LOG.severe("Error when patching the ConfigMap [" + configMapName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when patching the ConfigMap: " + configMapName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when patching the StatefulSet: " + configMapName, e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean updateConfigMapParam(String jobID, String paramName, String paramValue) {
        String configMapName = jobID;
        String countStr = "\"" + paramValue + "\"";
        String jsonPatchStr = "[{\"op\":\"replace\",\"path\":\"/data/" + paramName + "\",\"value\":" + countStr + "}]";
        try (Response response = coreApi.patchNamespacedConfigMapCall(configMapName, namespace, (Object)new V1Patch(jsonPatchStr), null, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.fine("ConfigMap parameter updated " + paramName + " = " + paramValue);
                boolean bl2 = true;
                return bl2;
            }
            LOG.severe("Error when patching the ConfigMap [" + configMapName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when patching the ConfigMap: " + configMapName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when patching the ConfigMap: " + configMapName, e);
        }
        return false;
    }

    public boolean updateConfigMapJobParam(JobAPI.Job job) {
        String jobAsEncodedStr = Base64.getEncoder().encodeToString(job.toByteArray());
        return this.updateConfigMapParam(job.getJobId(), "TWISTER2_JOB_OBJECT", jobAsEncodedStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeRestartCount(String jobID, String keyName) {
        String configMapName = jobID;
        String jsonPatchStr = "[{\"op\":\"remove\",\"path\":\"/data/" + keyName + "\"}]";
        try (Response response = coreApi.patchNamespacedConfigMapCall(configMapName, namespace, (Object)new V1Patch(jsonPatchStr), null, null, null, null, null).execute();){
            if (response.isSuccessful()) {
                LOG.fine("ConfigMap parameter removed " + keyName);
                boolean bl2 = true;
                return bl2;
            }
            LOG.severe("Error removing restartCount from the ConfigMap [" + configMapName + "]: " + response);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when patching the ConfigMap: " + configMapName, e);
            return false;
        }
        catch (ApiException e) {
            LOG.log(Level.SEVERE, "Exception when patching the ConfigMap: " + configMapName, e);
        }
        return false;
    }

    static {
        client = null;
    }
}

