/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.aurora;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.ILauncher;
import edu.iu.dsc.tws.api.scheduler.Twister2JobState;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.ComputeResourceUtils;
import edu.iu.dsc.tws.rsched.schedulers.aurora.AuroraClientController;
import edu.iu.dsc.tws.rsched.schedulers.aurora.AuroraContext;
import edu.iu.dsc.tws.rsched.schedulers.aurora.AuroraField;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuroraLauncher
implements ILauncher {
    private static final Logger LOG = Logger.getLogger(AuroraLauncher.class.getName());
    private Config config;

    public void initialize(Config conf) {
        this.config = conf;
    }

    public Twister2JobState launch(JobAPI.Job job) {
        String jobName = job.getJobName();
        String cluster = AuroraContext.auroraClusterName(this.config);
        String role = AuroraContext.role(this.config);
        String env = AuroraContext.environment(this.config);
        AuroraClientController controller = new AuroraClientController(cluster, role, env, jobName, true);
        String auroraFilename = AuroraContext.auroraScript((Config)this.config);
        Map<AuroraField, String> bindings = AuroraLauncher.constructEnvVariables(this.config, job);
        JobAPI.ComputeResource computeResource = job.getComputeResource(0);
        bindings.put(AuroraField.JOB_NAME, jobName);
        bindings.put(AuroraField.AURORA_WORKER_CLASS, AuroraContext.auroraWorkerClass(this.config));
        bindings.put(AuroraField.CPUS_PER_WORKER, computeResource.getCpu() + "");
        bindings.put(AuroraField.RAM_PER_WORKER, ComputeResourceUtils.getRamInBytes((JobAPI.ComputeResource)computeResource) + "");
        bindings.put(AuroraField.DISK_PER_WORKER, ComputeResourceUtils.getDiskInBytes((JobAPI.ComputeResource)computeResource) + "");
        bindings.put(AuroraField.NUMBER_OF_WORKERS, job.getNumberOfWorkers() + "");
        AuroraLauncher.logEnvVariables(bindings);
        Twister2JobState state = new Twister2JobState(controller.createJob(bindings, auroraFilename));
        return state;
    }

    public void close() {
    }

    public boolean killJob(String jobID) {
        String env;
        String role;
        String cluster = AuroraContext.auroraClusterName(this.config);
        AuroraClientController controller = new AuroraClientController(cluster, role = AuroraContext.role(this.config), env = AuroraContext.environment(this.config), jobID, true);
        boolean killedAuroraJob = controller.killJob();
        if (killedAuroraJob) {
            LOG.log(Level.INFO, "Aurora job kill command succeeded.");
        } else {
            LOG.log(Level.SEVERE, "Aurora job kill command failed.");
        }
        return killedAuroraJob;
    }

    public static Map<AuroraField, String> constructEnvVariables(Config config, JobAPI.Job job) {
        String jobName = SchedulerContext.jobName((Config)config);
        String jobDescriptionFile = SchedulerContext.createJobDescriptionFileName((String)job.getJobId());
        JobAPI.ComputeResource computeResource = job.getComputeResource(0);
        HashMap<AuroraField, String> envs = new HashMap<AuroraField, String>();
        envs.put(AuroraField.CORE_PACKAGE_FILENAME, SchedulerContext.corePackageFileName((Config)config));
        envs.put(AuroraField.JOB_PACKAGE_FILENAME, SchedulerContext.jobPackageFileName((Config)config));
        envs.put(AuroraField.AURORA_CLUSTER_NAME, AuroraContext.auroraClusterName(config));
        envs.put(AuroraField.ENVIRONMENT, AuroraContext.environment(config));
        envs.put(AuroraField.ROLE, AuroraContext.role(config));
        envs.put(AuroraField.JOB_NAME, jobName);
        envs.put(AuroraField.CPUS_PER_WORKER, computeResource.getCpu() + "");
        envs.put(AuroraField.RAM_PER_WORKER, computeResource.getRamMegaBytes() * 0x100000 + "");
        envs.put(AuroraField.DISK_PER_WORKER, computeResource.getDiskGigaBytes() * 1.073741824E9 + "");
        envs.put(AuroraField.NUMBER_OF_WORKERS, SchedulerContext.workerInstances((Config)config) + "");
        envs.put(AuroraField.TWISTER2_PACKAGES_PATH, SchedulerContext.packagesPath((Config)config));
        envs.put(AuroraField.JOB_DESCRIPTION_FILE, jobDescriptionFile);
        envs.put(AuroraField.USER_JOB_JAR_FILE, SchedulerContext.userJobJarFile((Config)config));
        envs.put(AuroraField.CLUSTER_TYPE, SchedulerContext.clusterType((Config)config));
        return envs;
    }

    public static void logEnvVariables(Map<AuroraField, String> envs) {
        Set<AuroraField> keys = envs.keySet();
        StringBuffer sb = new StringBuffer("All environment variables:");
        for (AuroraField key : keys) {
            sb.append("\n" + (Object)((Object)key) + ": " + envs.get((Object)key));
        }
        LOG.log(Level.INFO, sb.toString());
    }
}

