/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.core;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.common.config.ConfigLoader;
import edu.iu.dsc.tws.rsched.core.ResourceAllocator;
import edu.iu.dsc.tws.rsched.job.Twister2Submitter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class RuntimeManagerMain {
    private static final Logger LOG = Logger.getLogger(RuntimeManagerMain.class.getName());

    public static void main(String[] args) {
        RuntimeManagerMain.setupOptions();
        Options cmdOptions = null;
        try {
            cmdOptions = RuntimeManagerMain.setupOptions();
            DefaultParser parser = new DefaultParser();
            CommandLine cmd = parser.parse(cmdOptions, args);
            Config config = RuntimeManagerMain.loadConfigurations(cmd);
            LOG.log(Level.INFO, "The runtime controller...");
            String command = cmd.getOptionValue("command");
            RuntimeManagerMain.executeCommand(config, command);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("SubmitterMain", cmdOptions);
            throw new RuntimeException("Error parsing command line options: ", e);
        }
        catch (Throwable t) {
            String msg = "Un-expected error";
            LOG.log(Level.SEVERE, msg, t);
            throw new RuntimeException(msg, t);
        }
    }

    private static void executeCommand(Config cfg, String command) {
        switch (command) {
            case "kill": {
                ResourceAllocator.killJob(Context.jobId((Config)cfg), cfg);
                break;
            }
            case "restart": {
                Twister2Submitter.restartJob(Context.jobId((Config)cfg), cfg);
                break;
            }
            case "clear": {
                Twister2Submitter.clearJob(Context.jobId((Config)cfg), cfg);
                break;
            }
            case "clearall": {
                Twister2Submitter.clearAllJobs(cfg);
            }
        }
    }

    private static Config loadConfigurations(CommandLine cmd) {
        String twister2Home = cmd.getOptionValue("twister2_home");
        String configDir = cmd.getOptionValue("config_path");
        String cluster = cmd.getOptionValue("cluster");
        String jobID = cmd.getOptionValue("job_id");
        String command = cmd.getOptionValue("command");
        LOG.log(Level.INFO, String.format("Initializing process with twister_home: %s command: %s config_dir: %s cluster_type: %s", twister2Home, command, configDir, cluster));
        Config config = ConfigLoader.loadConfig((String)twister2Home, (String)configDir, (String)cluster);
        return Config.newBuilder().putAll(config).put(Context.TWISTER2_HOME.getKey(), (Object)twister2Home).put("config_dir", (Object)configDir).put("twister2.job.id", (Object)jobID).put("twister2.cluster.type", (Object)cluster).build();
    }

    private static Options setupOptions() {
        Options options = new Options();
        Option cluster = Option.builder((String)"c").desc("The name of the cluster configuration").longOpt("cluster").hasArgs().argName("Cluster name").required().build();
        Option configDirectory = Option.builder((String)"d").desc("The config directory").longOpt("config_path").hasArgs().argName("configuration directory").required().build();
        Option twister2Home = Option.builder((String)"t").desc("The class name of the container to launch").longOpt("twister2_home").hasArgs().argName("twister2 home").required().build();
        Option command = Option.builder((String)"m").desc("Command name").longOpt("command").hasArgs().argName("command").required().build();
        Option jobID = Option.builder((String)"j").desc("Job id").longOpt("job_id").hasArgs().argName("job id").build();
        options.addOption(twister2Home);
        options.addOption(cluster);
        options.addOption(configDirectory);
        options.addOption(command);
        options.addOption(jobID);
        return options;
    }
}

