/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.worker;

import com.google.protobuf.Message;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.resource.IPersistentVolume;
import edu.iu.dsc.tws.api.resource.ISenderToDriver;
import edu.iu.dsc.tws.api.resource.IVolatileVolume;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.api.resource.Twister2Worker;
import edu.iu.dsc.tws.api.resource.WorkerEnvironment;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.JobExecutionState;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.core.WorkerRuntime;
import java.util.logging.Logger;

public class Twister2WorkerStarter
implements IWorker {
    private static final Logger LOG = Logger.getLogger(Twister2WorkerStarter.class.getName());

    public void execute(Config config, JobAPI.Job job, IWorkerController workerController, IPersistentVolume persistentVolume, IVolatileVolume volatileVolume) {
        int workerID = workerController.getWorkerInfo().getWorkerID();
        WorkerEnvironment workerEnv = WorkerEnvironment.init((Config)config, (JobAPI.Job)job, (IWorkerController)workerController, (IPersistentVolume)persistentVolume, (IVolatileVolume)volatileVolume);
        String workerClass = job.getWorkerClassName();
        try {
            Object object = ReflectionUtils.newInstance((String)workerClass);
            Twister2Worker worker = (Twister2Worker)object;
            LOG.info("loaded worker class: " + workerClass);
            worker.execute(workerEnv);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.severe(String.format("failed to load the worker class %s", workerClass));
            throw new RuntimeException(e);
        }
        if (JobMasterContext.isJobMasterUsed((Config)config) && !job.getDriverClassName().isEmpty()) {
            ISenderToDriver senderToDriver = WorkerRuntime.getSenderToDriver();
            JobExecutionState.WorkerJobState workerState = JobExecutionState.WorkerJobState.newBuilder().setFailure(false).setJobName(config.getStringValue("twister2.job.id")).setWorkerMessage("Worker Completed").build();
            senderToDriver.sendToDriver((Message)workerState);
        }
    }
}

