/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.worker;

import edu.iu.dsc.tws.api.exceptions.Twister2Exception;
import edu.iu.dsc.tws.api.faulttolerance.Fault;
import edu.iu.dsc.tws.api.faulttolerance.FaultAcceptable;
import edu.iu.dsc.tws.api.faulttolerance.JobProgress;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobProgressImpl
extends JobProgress {
    private static final Logger LOG = Logger.getLogger(JobProgressImpl.class.getName());

    public static void init() {
        jobStatus = JobProgress.JobStatus.STARTING;
        workerExecuteCount = 0;
    }

    public static void setJobStatus(JobProgress.JobStatus jobStatus1) {
        jobStatus = jobStatus1;
    }

    public static void increaseWorkerExecuteCount() {
        ++workerExecuteCount;
    }

    public static void setRestartedWorkers(Collection<JobMasterAPI.WorkerInfo> restartedWorkers1) {
        restartedWorkers.clear();
        restartedWorkers.addAll(restartedWorkers1);
    }

    public static void faultOccurred(int wID) {
        for (FaultAcceptable fa : faultAcceptors) {
            try {
                fa.onFault(new Fault(wID));
            }
            catch (Twister2Exception e) {
                LOG.log(Level.WARNING, "Cannot propagate the failure", e);
            }
        }
    }
}

