/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.utils;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.Context;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.resource.IWorker;
import edu.iu.dsc.tws.api.resource.Twister2Worker;
import edu.iu.dsc.tws.api.util.KryoSerializer;
import edu.iu.dsc.tws.common.util.ReflectionUtils;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.proto.utils.ComputeResourceUtils;
import edu.iu.dsc.tws.rsched.utils.FileUtils;
import edu.iu.dsc.tws.rsched.worker.Twister2WorkerStarter;
import java.io.File;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class JobUtils {
    private static final Logger LOG = Logger.getLogger(JobUtils.class.getName());

    private JobUtils() {
    }

    public static boolean writeJobFile(JobAPI.Job job, String fileName) {
        byte[] jobBytes = job.toByteArray();
        return FileUtils.writeToFile(fileName, jobBytes, true);
    }

    public static JobAPI.Job readJobFile(String fileName) {
        try {
            byte[] fileBytes = FileUtils.readFromFile(fileName);
            JobAPI.Job.Builder builder = JobAPI.Job.newBuilder();
            return ((JobAPI.Job.Builder)builder.mergeFrom(fileBytes)).build();
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException("Failed to read the job file: " + fileName);
        }
    }

    public static Map<String, Object> readCommandLineOpts() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String commandOptions = System.getenv("TWISTER2_OPTIONS");
        if (commandOptions != null) {
            String[] configs;
            for (String config : configs = commandOptions.split(",")) {
                String[] options = config.split(":");
                if (options.length != 2) continue;
                ret.put(options[0], options[1]);
            }
        }
        return ret;
    }

    public static String jobClassPath(Config cfg, JobAPI.Job job, String wd) {
        StringBuilder classPathBuilder = new StringBuilder();
        if (job.getJobFormat().getType() == JobAPI.JobFormatType.JAR || job.getJobFormat().getType() == JobAPI.JobFormatType.PYTHON) {
            classPathBuilder.append(Paths.get(wd, job.getJobId(), job.getJobFormat().getJobFile()).toString());
        } else {
            File jobLib = Paths.get(wd, job.getJobId(), "lib").toFile();
            classPathBuilder.append(jobLib.getPath() + "/*");
        }
        return classPathBuilder.toString();
    }

    public static String systemClassPath(Config cfg) {
        String libDirectory = SchedulerContext.libDirectory((Config)cfg);
        String libFile = Paths.get(libDirectory, new String[0]).toString();
        return libFile + "/*";
    }

    public static Config overrideConfigs(JobAPI.Job job, Config config) {
        Config.Builder builder = Config.newBuilder().putAll(config);
        JobAPI.Config conf = job.getConfig();
        Map configMapSerialized = conf.getConfigByteMapMap();
        try {
            for (Map.Entry e : configMapSerialized.entrySet()) {
                String key = (String)e.getKey();
                byte[] bytes = ((ByteString)e.getValue()).toByteArray();
                Object object = new KryoSerializer().deserialize(bytes);
                builder.put(key, object);
            }
        }
        catch (Exception e) {
            LOG.severe("Error while overriding Configs " + e.getMessage());
        }
        return builder.build();
    }

    public static String getJobDescriptionFilePath(String workingDirectory, String jobFileName, Config config) {
        return Paths.get(workingDirectory, jobFileName + ".job").toAbsolutePath().toString();
    }

    public static String getJobDescriptionFilePath(String jobFileName, Config config) {
        String home = Context.twister2Home((Config)config);
        return Paths.get(home, jobFileName + ".job").toAbsolutePath().toString();
    }

    public static Config updateConfigs(JobAPI.Job job, Config config) {
        Config.Builder builder = Config.newBuilder().putAll(config);
        builder.put("twister2.resource.job.name", (Object)job.getJobName());
        builder.put("twister2.resource.job.worker.class", (Object)job.getWorkerClassName());
        builder.put("twister2.resource.worker.instances", (Object)job.getNumberOfWorkers());
        builder.put("twister2.job.id", (Object)job.getJobId());
        return builder.build();
    }

    public static JobAPI.ComputeResource getComputeResource(JobAPI.Job job, int index) {
        for (JobAPI.ComputeResource computeResource : job.getComputeResourceList()) {
            if (computeResource.getIndex() != index) continue;
            return computeResource;
        }
        return null;
    }

    public static String toString(JobAPI.Job job) {
        String jobStr = String.format("[jobName=%s], [jobID=%s], \n[numberOfWorkers=%s], [workerClass=%s]", job.getJobName(), job.getJobId(), job.getNumberOfWorkers(), job.getWorkerClassName());
        for (JobAPI.ComputeResource cr : job.getComputeResourceList()) {
            jobStr = jobStr + "\n" + ComputeResourceUtils.toString((JobAPI.ComputeResource)cr);
        }
        return jobStr;
    }

    public static String computeResourcesToPrint(JobAPI.Job job) {
        String cmStr = ComputeResourceUtils.toString((JobAPI.ComputeResource)job.getComputeResource(0));
        for (int i = 1; i < job.getComputeResourceList().size(); ++i) {
            cmStr = cmStr + System.lineSeparator() + ComputeResourceUtils.toString((JobAPI.ComputeResource)job.getComputeResource(i));
        }
        return cmStr;
    }

    public static String createJobPackageFileName(String jobID) {
        return jobID + ".tar.gz";
    }

    public static boolean isJobScalable(Config config, JobAPI.Job job) {
        if (job.getDriverClassName().isEmpty()) {
            return false;
        }
        boolean computeResourceScalable = job.getComputeResource(job.getComputeResourceCount() - 1).getScalable();
        if (!computeResourceScalable) {
            return false;
        }
        return !SchedulerContext.useOpenMPI((Config)config);
    }

    public static IWorker initializeIWorker(JobAPI.Job job) {
        String workerClass = job.getWorkerClassName();
        try {
            Object object = ReflectionUtils.newInstance((String)workerClass);
            if (object instanceof IWorker) {
                LOG.info("loaded worker class: " + workerClass);
                return (IWorker)object;
            }
            if (object instanceof Twister2Worker) {
                return new Twister2WorkerStarter();
            }
            throw new Twister2RuntimeException(String.format("Worker class [%s] is neither an instance of IWorker nor Twister2Worker interfaces.", workerClass));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.severe(String.format("failed to load the worker class %s", workerClass));
            throw new RuntimeException(e);
        }
    }
}

