/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.scp;

import edu.iu.dsc.tws.rsched.utils.ProcessUtils;
import java.util.logging.Logger;

public class ScpController {
    private static final Logger LOG = Logger.getLogger(ScpController.class.getName());
    private String scpOptions;
    private String scpConnection;
    private String sshOptions;
    private String sshConnection;

    public ScpController(String scpOptions, String scpConnection, String sshOptions, String sshConnection) {
        this.scpOptions = scpOptions;
        this.scpConnection = scpConnection;
        this.sshOptions = sshOptions;
        this.sshConnection = sshConnection;
    }

    public boolean mkdirsIfNotExists(String dir) {
        String command = String.format("ssh %s %s mkdir -p %s", this.sshOptions, this.sshConnection, dir);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }

    public boolean copyFromLocalFile(String source, String destination) {
        String command = String.format("scp %s %s %s:%s", this.scpOptions, source, this.scpConnection, destination);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }

    public boolean copyFromLocalDirectory(String source, String destination) {
        String command = String.format(" rsync %s -a %s %s:%s", this.scpOptions, source, this.scpConnection, destination);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }

    public boolean delete(String filePath) {
        String command = String.format("ssh %s %s rm -rf %s", this.sshOptions, this.sshConnection, filePath);
        return 0 == ProcessUtils.runProcess(command, null, false);
    }
}

