/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.s3;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.rsched.uploaders.s3.S3Context;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class S3Uploader
extends Thread
implements IUploader {
    private static final Logger LOG = Logger.getLogger(S3Uploader.class.getName());
    private Config config;
    private String jobID;
    private String localJobPackFile;
    private String s3File;
    private boolean uploaded = false;

    public void initialize(Config cnfg, String jbID) {
        this.config = cnfg;
        this.jobID = jbID;
    }

    @Override
    public void run() {
        String cmd = String.format("aws s3 cp %s %s", this.localJobPackFile, this.s3File);
        LOG.info("cmd for s3 Uploader: " + cmd);
        String[] fullCmd = new String[]{"bash", "-c", cmd};
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(fullCmd);
            p.waitFor();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when executing the command: " + cmd, e);
            return;
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Exception when waiting the command to complete: " + cmd, e);
            return;
        }
        int exitCode = p.exitValue();
        if (exitCode == 0) {
            this.uploaded = true;
            LOG.info("Job Package uploaded successfully to: " + this.s3File);
        } else {
            String failMsg = String.format("Some error occurred when uploading job package %s to s3: %s", this.localJobPackFile, this.s3File);
            LOG.severe(failMsg);
        }
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        String url;
        this.localJobPackFile = sourceLocation + "/" + SchedulerContext.jobPackageFileName((Config)this.config);
        this.s3File = S3Context.s3BucketName(this.config) + "/" + JobUtils.createJobPackageFileName(this.jobID);
        long linkExpDur = S3Context.linkExpirationDuration(this.config);
        String cmd = String.format("aws s3 presign %s --expires-in %s", this.s3File, linkExpDur);
        LOG.fine("cmd for s3 URL Generation: " + cmd);
        String[] fullCmd = new String[]{"bash", "-c", cmd};
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(fullCmd);
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            url = reader.readLine();
            p.waitFor();
        }
        catch (IOException e) {
            throw new UploaderException("Exception when executing the command: " + cmd, (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new UploaderException("Exception when waiting the script to complete: " + cmd, (Throwable)e);
        }
        int exitCode = p.exitValue();
        if (exitCode == 0) {
            LOG.fine("Job Package Download URL: " + url);
            try {
                URI uri = new URI(url);
                this.start();
                if (CheckpointingContext.startingFromACheckpoint((Config)this.config)) {
                    this.waitComplete();
                }
                return uri;
            }
            catch (URISyntaxException e) {
                throw new UploaderException("Can not generate URI for download link: " + url, (Throwable)e);
            }
        }
        String failMsg = String.format("Some error occurred when presigning job package %s at s3: %s", this.localJobPackFile, this.s3File);
        throw new UploaderException(failMsg);
    }

    private void waitComplete() {
        boolean done = false;
        while (!done) {
            try {
                this.join();
                done = true;
            }
            catch (InterruptedException e) {
                LOG.log(Level.WARNING, e.getMessage(), e);
                done = false;
            }
        }
    }

    public boolean complete() {
        this.waitComplete();
        return this.uploaded;
    }

    public boolean undo() {
        this.s3File = S3Context.s3BucketName(this.config) + "/" + JobUtils.createJobPackageFileName(this.jobID);
        String cmd = "aws s3 rm " + this.s3File;
        LOG.fine("cmd for s3 Remover: " + cmd);
        String[] fullCmd = new String[]{"bash", "-c", cmd};
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(fullCmd);
            p.waitFor();
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Exception when executing the command: " + cmd, e);
            return false;
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Exception when waiting the command to complete: " + cmd, e);
            return false;
        }
        int exitCode = p.exitValue();
        if (exitCode == 0) {
            LOG.info("Job Package removed successfully: " + this.s3File);
            return true;
        }
        String failMsg = String.format("Some error occurred when removing the job package %s", this.s3File);
        LOG.severe(failMsg);
        return false;
    }

    public void close() {
    }
}

