/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.k8s;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesContext;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.RequestObjectBuilder;
import edu.iu.dsc.tws.rsched.uploaders.k8s.DirectUploader;
import edu.iu.dsc.tws.rsched.uploaders.k8s.UploaderToWebServers;
import java.net.URI;
import java.util.List;
import java.util.logging.Logger;

public class K8sUploader
implements IUploader {
    private static final Logger LOG = Logger.getLogger(K8sUploader.class.getName());
    private IUploader uploader;

    public void initialize(Config cnfg, String jbID) {
        KubernetesController controller = KubernetesController.init(KubernetesContext.namespace(cnfg));
        List<String> webServerPodNames = controller.getUploaderWebServerPods(KubernetesContext.uploaderWebServerLabel(cnfg));
        if (webServerPodNames.size() == 0) {
            RequestObjectBuilder.setUploadMethod("client-to-pods");
            this.uploader = new DirectUploader();
        } else {
            this.uploader = new UploaderToWebServers(webServerPodNames);
        }
        this.uploader.initialize(cnfg, jbID);
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        return this.uploader.uploadPackage(sourceLocation);
    }

    public boolean complete() {
        return this.uploader.complete();
    }

    public boolean undo() {
        return this.uploader.undo();
    }

    public void close() {
        this.uploader.close();
    }
}

