/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.uploaders.hdfs;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.TypeUtils;
import edu.iu.dsc.tws.api.scheduler.IUploader;
import edu.iu.dsc.tws.api.scheduler.UploaderException;
import edu.iu.dsc.tws.rsched.uploaders.hdfs.HdfsContext;
import edu.iu.dsc.tws.rsched.uploaders.hdfs.HdfsController;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;

public class HdfsUploader
implements IUploader {
    private static final Logger LOG = Logger.getLogger(HdfsUploader.class.getName());
    private String destTopologyDirectoryURI;
    private Config config;
    private URI packageURI;
    private HdfsController controller;

    public void initialize(Config ipconfig, String jobID) {
        this.config = ipconfig;
        this.controller = this.getHdfsController();
        this.destTopologyDirectoryURI = HdfsContext.hdfsTopologiesDirectoryURI(this.config);
    }

    protected HdfsController getHdfsController() {
        return new HdfsController(HdfsContext.hadoopConfigDirectory(this.config), false);
    }

    protected boolean isLocalFileExists(String file) {
        return new File(file).isFile();
    }

    public URI uploadPackage(String sourceLocation) throws UploaderException {
        File file = new File(sourceLocation);
        String fileName = file.getName();
        this.packageURI = TypeUtils.getURI((String)(this.destTopologyDirectoryURI + "/" + fileName));
        if (!this.isLocalFileExists(sourceLocation)) {
            throw new UploaderException(String.format("Expected topology package file to be uploaded does not exist at '%s'", sourceLocation));
        }
        if (!this.controller.exists(this.destTopologyDirectoryURI)) {
            LOG.info(String.format("The destination directory does not exist. Creating it now at URI '%s'", this.destTopologyDirectoryURI));
            if (!this.controller.mkdirs(this.destTopologyDirectoryURI)) {
                throw new UploaderException(String.format("Failed to create directory for topology package at URI '%s'", this.destTopologyDirectoryURI));
            }
        } else {
            LOG.info(String.format("Target topology file already exists at '%s'. Overwriting it now", this.packageURI.toString()));
        }
        LOG.info(String.format("Uploading topology package at '%s' to target HDFS at '%s'", sourceLocation, this.packageURI.toString()));
        if (!this.controller.copyFromLocalFile(sourceLocation, this.packageURI.toString())) {
            throw new UploaderException(String.format("Failed to upload the topology package at '%s' to: '%s'", sourceLocation, this.packageURI.toString()));
        }
        try {
            return new URI(this.destTopologyDirectoryURI + '/' + fileName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid file path for topology package destination: " + this.destTopologyDirectoryURI, e);
        }
    }

    public boolean undo() {
        return this.controller.delete(this.packageURI.toString());
    }

    public void close() {
    }
}

