/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.checkpointing.CheckpointingClient;
import edu.iu.dsc.tws.api.exceptions.JobFaultyException;
import edu.iu.dsc.tws.api.exceptions.TimeoutException;
import edu.iu.dsc.tws.api.exceptions.Twister2RuntimeException;
import edu.iu.dsc.tws.api.resource.IAllJoinedListener;
import edu.iu.dsc.tws.api.resource.IWorkerController;
import edu.iu.dsc.tws.proto.jobmaster.JobMasterAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import mpi.MPI;
import mpi.MPIException;

public class MPIWorkerController
implements IWorkerController {
    private static final Logger LOG = Logger.getLogger(MPIWorkerController.class.getName());
    private int workerID;
    private int restartCount;
    private Map<Integer, JobMasterAPI.WorkerInfo> workerInfoMap = new HashMap<Integer, JobMasterAPI.WorkerInfo>();

    public MPIWorkerController(int workerID, Map<Integer, JobMasterAPI.WorkerInfo> workers, int restartCount) {
        this.workerID = workerID;
        this.workerInfoMap = workers;
        this.restartCount = restartCount;
    }

    public JobMasterAPI.WorkerInfo getWorkerInfo() {
        return this.workerInfoMap.get(this.workerID);
    }

    public JobMasterAPI.WorkerInfo getWorkerInfoForID(int id) {
        return this.workerInfoMap.get(id);
    }

    public int getNumberOfWorkers() {
        return this.workerInfoMap.size();
    }

    public List<JobMasterAPI.WorkerInfo> getJoinedWorkers() {
        return new ArrayList<JobMasterAPI.WorkerInfo>(this.workerInfoMap.values());
    }

    public List<JobMasterAPI.WorkerInfo> getAllWorkers() throws TimeoutException {
        return new ArrayList<JobMasterAPI.WorkerInfo>(this.workerInfoMap.values());
    }

    public int workerRestartCount() {
        return this.restartCount;
    }

    public void waitOnBarrier() throws TimeoutException {
        try {
            MPI.COMM_WORLD.barrier();
        }
        catch (MPIException e) {
            throw new Twister2RuntimeException("Failed to wait on barrier");
        }
    }

    public void waitOnBarrier(long timeLimit) throws TimeoutException, JobFaultyException {
        this.waitOnBarrier();
    }

    public void waitOnInitBarrier() throws TimeoutException {
        this.waitOnBarrier();
    }

    public CheckpointingClient getCheckpointingClient() {
        return null;
    }

    public boolean addAllJoinedListener(final IAllJoinedListener iAllJoinedListener) {
        new Thread("Twister2-MPIWorkerController-AllJoinedSupplier"){

            @Override
            public void run() {
                try {
                    iAllJoinedListener.allWorkersJoined(MPIWorkerController.this.getAllWorkers());
                }
                catch (TimeoutException e) {
                    LOG.log(Level.SEVERE, e.getMessage(), e);
                }
                LOG.fine("AllWorkersJoined event delivered from cache.");
            }
        }.start();
        return true;
    }
}

