/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.standalone;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.MPIContext;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class MPICommand {
    private static final Logger LOG = Logger.getLogger(MPICommand.class.getName());
    protected String workingDirectory;
    protected Config config;

    public MPICommand(Config cfg, String workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.config = cfg;
    }

    protected List<String> readFromFile(String filename) {
        Path path = new File(filename).toPath();
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<String> tempResult = Files.readAllLines(path);
            if (tempResult != null) {
                result.addAll(tempResult);
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to read from file. ", e);
        }
        return result;
    }

    protected String getNumberOfWorkers(JobAPI.Job job) {
        int numberOfWorkers = job.getNumberOfWorkers();
        if (JobMasterContext.isJobMasterUsed((Config)this.config) && !JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            ++numberOfWorkers;
        }
        return Integer.toString(numberOfWorkers);
    }

    protected String getClasspath(Config cfg, JobAPI.Job job) {
        String jobClassPath = JobUtils.jobClassPath(cfg, job, this.workingDirectory);
        LOG.log(Level.FINE, "Job class path: " + jobClassPath);
        String systemClassPath = JobUtils.systemClassPath(cfg);
        String classPath = jobClassPath + ":" + systemClassPath;
        return classPath;
    }

    protected abstract String[] killCommand();

    int getMemory(JobAPI.Job job) {
        int memory = 256;
        int mem = job.getComputeResource(0).getRamMegaBytes();
        if (mem > 0) {
            memory = mem;
        }
        return memory;
    }

    protected abstract String[] mpiCommand(String var1, JobAPI.Job var2);

    protected abstract void updateRestartCount(String[] var1, int var2);

    protected String mpirunPath() {
        String mpiRunFile = MPIContext.mpiRunFile((Config)this.config);
        if ("ompi/bin/mpirun".equals(mpiRunFile)) {
            if (SchedulerContext.copySystemPackage((Config)this.config)) {
                return "twister2-core/" + mpiRunFile;
            }
            return SchedulerContext.twister2Home((Config)this.config) + "/" + mpiRunFile;
        }
        return mpiRunFile;
    }

    protected String ldLibraryPath() {
        String mpiRunFile = MPIContext.mpiRunFile((Config)this.config);
        String current = System.getenv("LD_LIBRARY_PATH");
        if (mpiRunFile != null && mpiRunFile.endsWith("/bin/mpirun")) {
            if (current == null) {
                return mpiRunFile.replace("/bin/mpirun", "/lib");
            }
            return current + ":" + mpiRunFile.replace("/bin/mpirun", "/lib");
        }
        return current == null ? "" : current;
    }

    protected String getMapBy(JobAPI.Job job) {
        int cpusPerProc = 1;
        if (job.getComputeResourceCount() > 0) {
            double cpu = job.getComputeResource(0).getCpu();
            cpusPerProc = (int)Math.ceil(cpu);
        }
        return MPIContext.mpiMapBy((Config)this.config, (int)cpusPerProc);
    }

    protected String submittingTwister2Home() {
        if (SchedulerContext.copySystemPackage((Config)this.config)) {
            return "twister2-core";
        }
        return SchedulerContext.twister2Home((Config)this.config);
    }
}

