/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.nomad;

import com.hashicorp.nomad.apimodel.Job;
import com.hashicorp.nomad.apimodel.JobListStub;
import com.hashicorp.nomad.apimodel.NetworkResource;
import com.hashicorp.nomad.apimodel.Port;
import com.hashicorp.nomad.apimodel.Resources;
import com.hashicorp.nomad.apimodel.Task;
import com.hashicorp.nomad.apimodel.TaskGroup;
import com.hashicorp.nomad.apimodel.Template;
import com.hashicorp.nomad.javasdk.EvaluationResponse;
import com.hashicorp.nomad.javasdk.NomadApiClient;
import com.hashicorp.nomad.javasdk.NomadApiConfiguration;
import com.hashicorp.nomad.javasdk.NomadException;
import com.hashicorp.nomad.javasdk.ServerQueryResponse;
import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.api.config.SchedulerContext;
import edu.iu.dsc.tws.api.scheduler.IController;
import edu.iu.dsc.tws.master.JobMasterContext;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.nomad.NomadContext;
import edu.iu.dsc.tws.rsched.uploaders.scp.ScpContext;
import edu.iu.dsc.tws.rsched.utils.JobUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NomadController
implements IController {
    private static final Logger LOG = Logger.getLogger(NomadController.class.getName());
    private Config config;
    private boolean isVerbose;

    public NomadController(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }

    public void initialize(Config cfg) {
        this.config = cfg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(JobAPI.Job job) {
        String uri = NomadContext.nomadSchedulerUri(this.config);
        NomadApiClient nomadApiClient = new NomadApiClient(new NomadApiConfiguration.Builder().setAddress(uri).build());
        Job nomadJob = this.getJob(job);
        try {
            EvaluationResponse response = nomadApiClient.getJobsApi().register(nomadJob);
            LOG.log(Level.INFO, "Submitted job to nomad: " + response);
        }
        catch (NomadException | IOException e) {
            LOG.log(Level.SEVERE, "Failed to submit the job: ", e);
        }
        finally {
            this.closeClient(nomadApiClient);
        }
        return false;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean kill(JobAPI.Job job) {
        String jobID = job.getJobId();
        String uri = NomadContext.nomadSchedulerUri(this.config);
        LOG.log(Level.INFO, "Killing Job " + jobID);
        NomadApiClient nomadApiClient = new NomadApiClient(new NomadApiConfiguration.Builder().setAddress(uri).build());
        try {
            Job nomadJob = NomadController.getRunningJob(nomadApiClient, job.getJobId());
            if (nomadJob == null) {
                LOG.log(Level.INFO, "Cannot find the running job: " + job.getJobId());
                boolean bl = false;
                return bl;
            }
            nomadApiClient.getJobsApi().deregister(nomadJob.getId());
        }
        catch (NomadException | IOException | RuntimeException e) {
            LOG.log(Level.SEVERE, "Failed to terminate job " + jobID + " with error: " + e.getMessage(), e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeClient(nomadApiClient);
        }
        return true;
    }

    private void closeClient(NomadApiClient nomadApiClient) {
        try {
            if (nomadApiClient != null) {
                nomadApiClient.close();
            }
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, String.format("Error closing client: %s", e.getMessage()), e);
        }
    }

    private Job getJob(JobAPI.Job job) {
        String jobID = job.getJobId();
        Job nomadJob = new Job();
        nomadJob.setId(jobID);
        nomadJob.setName(jobID);
        nomadJob.setType("batch");
        nomadJob.addTaskGroups(new TaskGroup[]{this.getTaskGroup(job)});
        nomadJob.setDatacenters(Arrays.asList("dc1"));
        nomadJob.setMeta(NomadController.getMetaData(job));
        return nomadJob;
    }

    private static List<JobListStub> getRunningJobList(NomadApiClient apiClient) {
        ServerQueryResponse response;
        try {
            response = apiClient.getJobsApi().list();
        }
        catch (NomadException | IOException e) {
            LOG.log(Level.SEVERE, "Error when attempting to fetch job list", e);
            throw new RuntimeException(e);
        }
        return (List)response.getValue();
    }

    private static Job getRunningJob(NomadApiClient apiClient, String jobID) {
        List<JobListStub> jobs = NomadController.getRunningJobList(apiClient);
        for (JobListStub job : jobs) {
            Job jobActual;
            try {
                jobActual = (Job)apiClient.getJobsApi().info(job.getId()).getValue();
            }
            catch (NomadException | IOException e) {
                String msg = "Failed to retrieve job info for job " + job.getId() + " part of job " + jobID;
                LOG.log(Level.SEVERE, msg, e);
                throw new RuntimeException(msg, e);
            }
            if (!jobID.equals(jobActual.getName())) continue;
            return jobActual;
        }
        return null;
    }

    private TaskGroup getTaskGroup(JobAPI.Job job) {
        TaskGroup taskGroup = new TaskGroup();
        if (JobMasterContext.jobMasterRunsInClient((Config)this.config)) {
            taskGroup.setCount(Integer.valueOf(job.getNumberOfWorkers()));
        } else {
            taskGroup.setCount(Integer.valueOf(job.getNumberOfWorkers() + 1));
        }
        taskGroup.setName(job.getJobId());
        taskGroup.addTasks(new Task[]{this.getShellDriver(job)});
        return taskGroup;
    }

    private static Map<String, String> getMetaData(JobAPI.Job job) {
        String jobID = job.getJobId();
        HashMap<String, String> metaData = new HashMap<String, String>();
        metaData.put("NOMAD_JOB_NAME", jobID);
        return metaData;
    }

    private Task getShellDriver(JobAPI.Job job) {
        String taskName = job.getJobId();
        Task task = new Task();
        String workingDirectory = NomadContext.workingDirectory(this.config);
        String jobWorkingDirectory = Paths.get(workingDirectory, job.getJobId()).toString();
        String configDirectoryName = Paths.get(workingDirectory, job.getJobId(), SchedulerContext.clusterType((Config)this.config)).toString();
        String corePackageFile = SchedulerContext.temporaryPackagesPath((Config)this.config) + "/" + SchedulerContext.corePackageFileName((Config)this.config);
        String jobPackageFile = SchedulerContext.temporaryPackagesPath((Config)this.config) + "/" + SchedulerContext.jobPackageFileName((Config)this.config);
        String nomadScriptContent = this.getNomadScriptContent(this.config, configDirectoryName);
        task.setName(taskName);
        task.setDriver("raw_exec");
        task.addConfig("command", (Object)"/bin/sh");
        String[] args = this.workerProcessCommand(workingDirectory, job);
        task.addConfig("args", (Object)args);
        Template template = new Template();
        template.setEmbeddedTmpl(nomadScriptContent);
        template.setDestPath("nomad.sh");
        task.addTemplates(new Template[]{template});
        Resources resourceReqs = new Resources();
        String portNamesConfig = NomadContext.networkPortNames(this.config);
        String[] portNames = portNamesConfig.split(",");
        Port[] ports = new Port[portNames.length];
        int i = 0;
        for (String p : portNames) {
            ports[i] = new Port().setLabel(p);
            ++i;
        }
        NetworkResource networkResource = new NetworkResource();
        networkResource.addDynamicPorts(ports);
        resourceReqs.addNetworks(new NetworkResource[]{networkResource});
        JobAPI.ComputeResource computeResource = JobUtils.getComputeResource(job, 0);
        if (computeResource == null) {
            LOG.log(Level.SEVERE, "Error: there is no compute resource");
            return null;
        }
        int cpu = (int)computeResource.getCpu();
        int disk = (int)computeResource.getDiskGigaBytes();
        int memory = computeResource.getRamMegaBytes();
        resourceReqs.setCpu(Integer.valueOf(cpu * 200));
        resourceReqs.setMemoryMb(Integer.valueOf(memory));
        resourceReqs.setDiskMb(Integer.valueOf(disk * 1024));
        LOG.log(Level.INFO, "Compute resources are " + cpu + " " + memory + " " + disk);
        HashMap<String, String> envVars = new HashMap<String, String>();
        envVars.put("WORKING_DIRECTORY_ENV", NomadContext.workingDirectory(this.config));
        if (!NomadContext.sharedFileSystem(this.config)) {
            envVars.put("DOWNLOAD_PACKAGE_ENV", "false");
        } else {
            envVars.put("DOWNLOAD_PACKAGE_ENV", "true");
        }
        envVars.put("CORE_PACKAGE_ENV", corePackageFile);
        envVars.put("JOB_PACKAGE_ENV", jobPackageFile);
        task.setEnv(envVars);
        task.setResources(resourceReqs);
        return task;
    }

    private String getScriptPath(Config cfg, String jWorkingDirectory) {
        String shellScriptName = NomadContext.shellScriptName(cfg);
        return Paths.get(jWorkingDirectory, shellScriptName).toString();
    }

    private String getNomadScriptContent(Config cfg, String jConfigDir) {
        String shellDirectoryPath = this.getScriptPath(cfg, jConfigDir);
        try {
            return new String(Files.readAllBytes(Paths.get(shellDirectoryPath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            String msg = "Failed to read nomad script from " + NomadContext.shellScriptName(cfg) + " . Please check file path! - " + shellDirectoryPath;
            LOG.log(Level.SEVERE, msg, e);
            throw new RuntimeException(msg, e);
        }
    }

    private String[] workerProcessCommand(String workingDirectory, JobAPI.Job job) {
        String twister2Home = Paths.get(workingDirectory, job.getJobId()).toString();
        String configDirectoryName = "";
        List<String> mpiCommand = this.workerProcessCommand(this.getScriptPath(this.config, configDirectoryName));
        Map<String, Object> map = this.workerCommandArguments(this.config, workingDirectory, job);
        String jobId = job.getJobId();
        String runIncLient = null;
        runIncLient = JobMasterContext.jobMasterRunsInClient((Config)this.config) ? "true" : "false";
        mpiCommand.add(runIncLient);
        mpiCommand.add(map.get("java_props").toString());
        mpiCommand.add(map.get("classpath").toString());
        mpiCommand.add(map.get("container_class").toString());
        mpiCommand.add(job.getJobId());
        mpiCommand.add(twister2Home);
        mpiCommand.add(jobId);
        mpiCommand.add(SchedulerContext.jobPackageUrl((Config)this.config));
        mpiCommand.add(SchedulerContext.corePackageUrl((Config)this.config));
        mpiCommand.add(SchedulerContext.downloadMethod((Config)this.config));
        mpiCommand.add(ScpContext.uploaderJobDirectory(this.config));
        LOG.log(Level.FINE, String.format("Command %s", mpiCommand));
        String[] array = new String[mpiCommand.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = mpiCommand.get(i);
        }
        return array;
    }

    private Map<String, Object> workerCommandArguments(Config cfg, String workingDirectory, JobAPI.Job job) {
        HashMap<String, Object> commands = new HashMap<String, Object>();
        commands.put("procs", job.getNumberOfWorkers());
        String jobClassPath = JobUtils.jobClassPath(cfg, job, workingDirectory);
        LOG.log(Level.FINE, "Job class path: " + jobClassPath);
        String systemClassPath = JobUtils.systemClassPath(cfg);
        String classPath = jobClassPath + ":" + systemClassPath;
        commands.put("classpath", classPath);
        commands.put("java_props", "");
        commands.put("container_class", job.getWorkerClassName());
        return commands;
    }

    private List<String> workerProcessCommand(String mpiScript) {
        ArrayList<String> slurmCmd = new ArrayList<String>(Collections.singletonList(mpiScript));
        return slurmCmd;
    }

    public String createPersistentJobDirName(String jobID) {
        return SchedulerContext.nfsServerPath((Config)this.config) + "/" + jobID;
    }
}

