/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.master;

import edu.iu.dsc.tws.api.config.Config;
import edu.iu.dsc.tws.checkpointing.util.CheckpointingContext;
import edu.iu.dsc.tws.master.IJobTerminator;
import edu.iu.dsc.tws.proto.system.job.JobAPI;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesUtils;
import java.util.ArrayList;
import java.util.logging.Logger;

public class JobTerminator
implements IJobTerminator {
    private static final Logger LOG = Logger.getLogger(JobTerminator.class.getName());
    private KubernetesController controller;
    private Config config;

    public JobTerminator(Config config, KubernetesController controller) {
        this.config = config;
        this.controller = controller;
    }

    public boolean terminateJob(String jobID, JobAPI.JobState finalState) {
        ArrayList<String> ssNameLists = this.controller.getJobWorkerStatefulSets(jobID);
        boolean ssForWorkersDeleted = true;
        for (String ssName : ssNameLists) {
            ssForWorkersDeleted &= this.controller.deleteStatefulSet(ssName);
        }
        String serviceName = KubernetesUtils.createServiceName(jobID);
        boolean serviceForWorkersDeleted = this.controller.deleteService(serviceName);
        boolean pvcDeleted = true;
        if (CheckpointingContext.isCheckpointingEnabled((Config)this.config)) {
            if (finalState != JobAPI.JobState.FAILED) {
                pvcDeleted = this.controller.deletePersistentVolumeClaim(jobID);
            }
        } else {
            pvcDeleted = this.controller.deletePersistentVolumeClaim(jobID);
        }
        boolean configMapDeleted = this.controller.deleteConfigMap(jobID);
        String jobMasterServiceName = KubernetesUtils.createJobMasterServiceName(jobID);
        boolean serviceForJobMasterDeleted = this.controller.deleteService(jobMasterServiceName);
        String jobMasterStatefulSetName = KubernetesUtils.createJobMasterStatefulSetName(jobID);
        boolean ssForJobMasterDeleted = this.controller.deleteStatefulSet(jobMasterStatefulSetName);
        JobTerminator jobTerminator = this;
        jobTerminator.controller.close();
        return ssForWorkersDeleted && serviceForWorkersDeleted && serviceForJobMasterDeleted && pvcDeleted && ssForJobMasterDeleted && configMapDeleted;
    }
}

