/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.logger;

import edu.iu.dsc.tws.rsched.schedulers.k8s.logger.JobLogger;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.Response;

public class WorkerLogger
extends Thread {
    private static final Logger LOG = Logger.getLogger(WorkerLogger.class.getName());
    private String namespace;
    private String podName;
    private String containerName;
    private String id;
    private String logFileName;
    private String logsDir;
    private CoreV1Api coreV1Api;
    private JobLogger jobLogger;
    private boolean stop = false;
    private InputStream logStream;
    private Response response;

    public WorkerLogger(String namespace, String podName, String containerName, String id, String logsDir, CoreV1Api coreV1Api, JobLogger jobLogger) {
        this.namespace = namespace;
        this.podName = podName;
        this.containerName = containerName;
        this.id = id;
        this.logsDir = logsDir;
        this.coreV1Api = coreV1Api;
        this.jobLogger = jobLogger;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public void run() {
        block5: {
            Path logfile = this.createLogFile();
            LOG.info("Starting to log for " + this.id + " to: " + this.logFileName);
            try {
                this.logStream = this.streamContainerLog();
                Files.copy(this.logStream, logfile, StandardCopyOption.REPLACE_EXISTING);
                if (!this.stop) {
                    this.logStream.close();
                    this.response.close();
                    LOG.info("Logging completed for " + this.id + " to: " + this.logFileName);
                }
            }
            catch (ApiException e) {
                if (!this.stop) {
                    LOG.log(Level.SEVERE, "Cannot get the log stream for " + this.id, e);
                }
            }
            catch (IOException e) {
                if (this.stop) break block5;
                LOG.log(Level.SEVERE, "Cannot get the log stream for " + this.id, e);
            }
        }
        this.jobLogger.workerLoggerCompleted(this.id);
    }

    private Path createLogFile() {
        this.logFileName = this.logsDir + "/" + this.id + "-0.log";
        Path logfile = Paths.get(this.logFileName, new String[0]);
        if (Files.notExists(logfile, new LinkOption[0])) {
            return logfile;
        }
        List<Path> existingWorkerLogFiles = this.getWorkerFiles();
        LOG.fine("Existing log files for worker: ");
        existingWorkerLogFiles.stream().map(f -> f.toString()).forEach(LOG::fine);
        this.renameOlderLogFiles(existingWorkerLogFiles);
        return logfile;
    }

    private void renameOlderLogFiles(List<Path> logFiles) {
        TreeMap filesMap = new TreeMap(Collections.reverseOrder());
        for (Path path : logFiles) {
            int lastDashIndex = path.toString().lastIndexOf("-");
            int lastDotIndex = path.toString().lastIndexOf(".");
            int logFileIndex = Integer.parseInt(path.toString().substring(lastDashIndex + 1, lastDotIndex));
            filesMap.put(logFileIndex, path);
        }
        for (Map.Entry entry : filesMap.entrySet()) {
            String index = "-" + entry.getKey() + ".";
            String toReplace = "-" + ((Integer)entry.getKey() + 1) + ".";
            String newLogFile = ((Path)entry.getValue()).toString().replace(index, toReplace);
            try {
                Files.move((Path)entry.getValue(), Paths.get(newLogFile, new String[0]), new CopyOption[0]);
                LOG.fine("Log file " + entry.getValue() + " renamed to " + newLogFile);
            }
            catch (IOException e) {
                LOG.log(Level.WARNING, "Cannot rename log file: " + entry.getValue() + " to " + newLogFile, e);
            }
        }
    }

    private List<Path> getWorkerFiles() {
        List<Path> list;
        block8: {
            Stream<Path> walk = Files.walk(Paths.get(this.logsDir, new String[0]), new FileVisitOption[0]);
            try {
                List<Path> workerFiles;
                list = workerFiles = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(x -> x.toString().contains(this.id)).collect(Collectors.toList());
                if (walk == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walk != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Exception when  getting log file list.", e);
                    return new LinkedList<Path>();
                }
            }
            walk.close();
        }
        return list;
    }

    public InputStream streamContainerLog() throws ApiException, IOException {
        Integer sinceSeconds = null;
        Integer tailLines = null;
        boolean timestamps = false;
        Call call = this.coreV1Api.readNamespacedPodLogCall(this.podName, this.namespace, this.containerName, Boolean.valueOf(true), null, "false", Boolean.valueOf(false), sinceSeconds, tailLines, Boolean.valueOf(timestamps), null);
        this.response = call.execute();
        if (!this.response.isSuccessful()) {
            throw new ApiException(this.response.code(), "Logs request failed: " + this.response.code());
        }
        return this.response.body().byteStream();
    }

    public void stopLogging() {
        try {
            this.logStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.response.body().close();
        this.response.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerLogger that = (WorkerLogger)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

