/*
 * Decompiled with CFR 0.152.
 */
package edu.iu.dsc.tws.rsched.schedulers.k8s.client;

import edu.iu.dsc.tws.rsched.schedulers.k8s.KubernetesController;
import edu.iu.dsc.tws.rsched.schedulers.k8s.client.JobEndListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public final class JobEndWatcher
extends Thread {
    private static final Logger LOG = Logger.getLogger(JobEndWatcher.class.getName());
    private String jobID;
    private KubernetesController controller;
    private boolean stop = false;
    private List<JobEndListener> jobEndListeners = Collections.synchronizedList(new LinkedList());
    private static JobEndWatcher jobEndWatcher;
    private static final long CHECK_INTERVAL = 1000L;

    public static synchronized JobEndWatcher init(String namespace, String jobID) {
        if (jobEndWatcher != null) {
            return jobEndWatcher;
        }
        jobEndWatcher = new JobEndWatcher(namespace, jobID);
        jobEndWatcher.start();
        return jobEndWatcher;
    }

    private JobEndWatcher(String namespace, String jobID) {
        this.controller = KubernetesController.init(namespace);
        this.jobID = jobID;
    }

    public void addJobEndListener(JobEndListener jobEndListener) {
        this.jobEndListeners.add(jobEndListener);
    }

    @Override
    public void run() {
        while (!this.stop) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.stop || this.controller.getJobConfigMap(this.jobID) != null) continue;
            this.jobEndListeners.forEach(JobEndListener::jobEnded);
            LOG.info("Job ended...");
            return;
        }
    }

    public void stopWatcher() {
        this.stop = true;
        jobEndWatcher.interrupt();
    }
}

